#ifndef SETTINGSDLG_H
#define SETTINGSDLG_H

#include <QDialog>
#include <QSettings>

#include "remote.h"

class QWidget;
class QHBoxLayout;
class QVBoxLayout;
class QPushButton;
class QLabel;
class Remote;

class SettingsDlg : public QDialog
{
    Q_OBJECT
public:
    SettingsDlg(QWidget *parent = 0);
    ~SettingsDlg();

private slots:
    void showAdvSettingsDlg();
    void showSelectRemoteDlg();
    void showAboutDlg();
    void setRemote(Remote);
    void setRemote(const QString &name);
    void updateRemoteInfo();
    void rateUpClicked();
    void rateDownClicked();

private:
    void enableRateBtns(bool enable = true);
    void processRemoteChange();
    void processRatingSent();
    void setBusy(bool busy = true);

private:
    Remote m_remote;

    QVBoxLayout *m_layout;
    QHBoxLayout *m_btnLayout;
    QHBoxLayout *m_remoteNameLayout;
    QPushButton *m_advSettingsBtn;
    QPushButton *m_selectRemoteBtn;
    QPushButton *m_rateUpBtn;
    QPushButton *m_rateDownBtn;
    QPushButton *m_aboutBtn;
    QLabel *m_remoteNameLabel;
    QLabel *m_ratingLabel;
};

#endif

