#include "settingsdlg.h"
#include "advsettingsdlg.h"
#include "selectremotedlg.h"
#include "aboutdlg.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QWidget>
#include <QDialog>
#include <QPushButton>
#include <QLabel>
#include <QDebug>

SettingsDlg::SettingsDlg(QWidget *parent)
    : QDialog(parent)
{
    QSettings settings(this);
    m_layout = new QVBoxLayout(this);
    m_btnLayout = new QHBoxLayout();
    m_remoteNameLayout = new QHBoxLayout();
    
    m_advSettingsBtn = new QPushButton(tr("Advanced"), this);
    m_selectRemoteBtn = new QPushButton(tr("Select remote"), this);
    m_aboutBtn = new QPushButton(tr("About"), this);
    m_rateUpBtn = new QPushButton(
            QIcon(settings.value("rateUpIcon",
                "/usr/share/icons/hicolor/48x48/hildon/chat_smiley_happy.png").
                toString()),
            "", this);
    m_rateDownBtn = new QPushButton(
            QIcon(settings.value("rateDownIcon",
                "/usr/share/icons/hicolor/48x48/hildon/chat_smiley_sad.png").
                toString()),
            "", this);
    m_rateUpBtn->setMaximumSize(72, 72);
    m_rateDownBtn->setMaximumSize(72, 72);

    m_btnLayout->addWidget(m_advSettingsBtn);
    m_btnLayout->addWidget(m_selectRemoteBtn);
    m_btnLayout->addWidget(m_aboutBtn);

    m_remoteNameLabel = new QLabel(this);
    m_ratingLabel = new QLabel(this);
    m_remoteNameLayout->addWidget(m_remoteNameLabel);
    m_remoteNameLayout->addWidget(m_ratingLabel);
    m_remoteNameLayout->addWidget(m_rateUpBtn);
    m_remoteNameLayout->addWidget(m_rateDownBtn);

    connect(m_advSettingsBtn, SIGNAL(clicked()),
            this, SLOT(showAdvSettingsDlg()));
    connect(m_selectRemoteBtn, SIGNAL(clicked()),
            this, SLOT(showSelectRemoteDlg()));
    connect(m_aboutBtn, SIGNAL(clicked()),
            this, SLOT(showAboutDlg()));
    connect(m_rateUpBtn, SIGNAL(clicked()),
            this, SLOT(rateUpClicked()));
    connect(m_rateDownBtn, SIGNAL(clicked()),
            this, SLOT(rateDownClicked()));
 
    m_layout->addLayout(m_remoteNameLayout);
    m_layout->addLayout(m_btnLayout);
    this->setLayout(m_layout);

    QString selectedRemote = QSettings(this).value("remoteName", "").toString();
    if (selectedRemote == "") {
        m_remoteNameLabel->setText("No remote selected");
        enableRateBtns(false);
    } else {
        setRemote(selectedRemote);
        m_remote.updateInfo();
        setBusy();
    }
}

SettingsDlg::~SettingsDlg()
{
    delete m_advSettingsBtn;
    delete m_selectRemoteBtn;
    delete m_rateUpBtn;
    delete m_rateDownBtn;
    delete m_aboutBtn;
    delete m_remoteNameLabel;
    delete m_ratingLabel;
    delete m_btnLayout;
    delete m_remoteNameLayout;
    delete m_layout;
}

void SettingsDlg::setBusy(bool busy)
{
    setAttribute(Qt::WA_Maemo5ShowProgressIndicator, busy);
    setEnabled(!busy);
}

void SettingsDlg::showAdvSettingsDlg()
{
    AdvSettingsDlg dlg(this);
    dlg.exec();
}

void SettingsDlg::showSelectRemoteDlg()
{
    SelectRemoteDlg dlg(this);
    connect(&dlg, SIGNAL(remoteChanged(Remote)),
            this, SLOT(setRemote(Remote)));
    dlg.exec();
}

void SettingsDlg::showAboutDlg()
{
    AboutDlg dlg(this);
    dlg.exec();
}

void SettingsDlg::setRemote(Remote r)
{
    m_remote = r;
    processRemoteChange();
    updateRemoteInfo();
}

void SettingsDlg::setRemote(const QString &name)
{
    setBusy();
    m_remote = Remote(name);
    processRemoteChange();
    m_remote.updateInfo();  // request update from server
}

void SettingsDlg::processRemoteChange()
{
    connect(&m_remote, SIGNAL(infoUpdated()),
            this, SLOT(updateRemoteInfo()));
    enableRateBtns();
}

void SettingsDlg::updateRemoteInfo()
{
    setBusy(false);
    m_remoteNameLabel->setText(m_remote.mfg() + " " + m_remote.name());
    m_ratingLabel->setText(tr("Rating") + ": "
            + QString::number(m_remote.rating()));
}

void SettingsDlg::rateUpClicked()
{
    m_remote.sendRating(Rating::Up);
    processRatingSent();
}

void SettingsDlg::rateDownClicked()
{
    m_remote.sendRating(Rating::Down);
    processRatingSent();
}

void SettingsDlg::processRatingSent()
{
    enableRateBtns(false);
    m_remote.updateInfo();
}

void SettingsDlg::enableRateBtns(bool enable)
{
    m_rateUpBtn->setEnabled(enable);
    m_rateDownBtn->setEnabled(enable);
}


