#ifndef SELECTREMOTEDLG_H
#define SELECTREMOTEDLG_H

#include <QDialog>
#include <QString>
#include <QMap>

#include "remotedb.h"
#include "remotedbmgr.h"

class QHBoxLayout;
class QListWidget;
class QListWidgetItem;
class QSettings;
class QNetworkAccessManager;
class QNetworkReply;
class QWidget;
class QPushButton;
class QLabel;

class SelectRemoteDlg : public QDialog
{
    Q_OBJECT

public:
    SelectRemoteDlg(QWidget *parent);
    ~SelectRemoteDlg();

private slots:
    void alphabetItemChanged(QListWidgetItem *current,
                             QListWidgetItem *previous);
    void mfgItemChanged(QListWidgetItem *current, QListWidgetItem *previous);
    void downloadRemote();
    void setDB(RemoteDB *db);

signals:
    void remoteChanged(Remote);

private:
    RemoteDBMgr remoteDBMgr;

    QLabel *remoteNameLabel;
    QHBoxLayout *layout;
    QListWidget *alphabetList;
    QListWidget *mfgList;
    QListWidget *modelList;
    QPushButton *downloadBtn;
    RemoteDB *remoteDB;

    void setBusy(bool busy = true);
};

#endif

