#include <QListWidget>
#include "remotelistwidgetitem.h"

RemoteListWidgetItem::RemoteListWidgetItem(Remote *remote, QListWidget *parent)
    : QListWidgetItem(parent, 1337), m_remote(remote)
{
    setFlags(Qt::NoItemFlags|Qt::ItemIsSelectable|Qt::ItemIsEnabled);
}

//overrides QListWidgetItem::data
QVariant RemoteListWidgetItem::data(int role) const
{
    QString str = m_remote->name() 
        + " (" + QString::number(m_remote->rating()) + ")";
    switch (role) {
        case Qt::DisplayRole:
            return QVariant(str);
        default:
            return QVariant();
    }
}

