#ifndef REMOTE_H
#define REMOTE_H

#include <QObject>
#include <QString>
#include <QSettings>

#include "rating.h"

class QNetworkReply;
class QNetworkAccessManager;

class Remote : public QObject
{
    Q_OBJECT

public:
    Remote();
    Remote(const QString &name, const QString &mfg = "",
            int rating = 0, int voteCount = 0);
    Remote(const Remote &);
    Remote &operator=(const Remote &);
    bool operator==(const Remote &other) const;
    ~Remote();

    //getters
    QString name()  const { return m_name; }
    QString mfg()   const { return m_mfg; }
    int rating()    const { return m_rating; }
    int voteCount() const { return m_voteCount; }

public slots:
    void saveToFile();
    void updateInfo();
    void sendRating(Rating::Rating);

private slots:
    void remoteDownloadFinished(QNetworkReply *reply);
    void infoRequestFinished(QNetworkReply *reply);

signals:
    void infoUpdated();
    void saveFinished();

private:
    QString m_name;
    QString m_mfg;
    int m_rating;
    int m_voteCount;

    QNetworkAccessManager *m_infoNAM;
    QNetworkAccessManager *m_remoteNAM;
    QNetworkAccessManager *m_ratingNAM;
};

#endif

