#include "remote.h"

#include <cstdlib>

#include <QString>
#include <QFile>
#include <QNetworkAccessManager>
#include <QNetworkRequest>
#include <QNetworkReply>
#include <QUrl>

Remote::Remote()
    : m_name("")
    , m_mfg("")
    , m_rating(0)
    , m_voteCount(0)
    , m_infoNAM(NULL)
    , m_remoteNAM(NULL)
    , m_ratingNAM(NULL)
{
}

Remote::Remote(const QString &name, const QString &mfg,
        int rating, int voteCount)
    : m_name(name)
    , m_mfg(mfg)
    , m_rating(rating)
    , m_voteCount(voteCount)
    , m_infoNAM(NULL)
    , m_remoteNAM(NULL)
    , m_ratingNAM(NULL)
{
}

Remote::Remote(const Remote &r)
    : QObject()
    , m_name(r.m_name)
    , m_mfg(r.m_mfg)
    , m_rating(r.m_rating)
    , m_voteCount(r.m_voteCount)
    , m_infoNAM(NULL)
    , m_remoteNAM(NULL)
    , m_ratingNAM(NULL)
{
}

Remote::~Remote()
{
    delete m_infoNAM;
    delete m_remoteNAM;
    delete m_ratingNAM;
}

Remote &Remote::operator=(const Remote &other)
{
    if (this != &other) {
        m_name = other.m_name;
        m_mfg = other.m_mfg;
        m_rating = other.m_rating;
        m_voteCount = other.m_voteCount;
    }
    return *this;
}

bool Remote::operator==(const Remote &other) const
{
    return (m_name == other.m_name &&
            m_mfg == other.m_mfg &&
            m_rating == other.m_rating &&
            m_voteCount == other.m_voteCount);
}

void Remote::saveToFile()
{
    if (!m_name.isEmpty()) {
        if (!m_remoteNAM) {
            m_remoteNAM = new QNetworkAccessManager(this);
            connect(m_remoteNAM, SIGNAL(finished(QNetworkReply*)),
                    this, SLOT(remoteDownloadFinished(QNetworkReply*)));
        }
        QSettings settings(this);
        QString url = settings.value("baseUrl",
            "http://mercury.wipsl.com/irwi/").toString()
            + "uploaded/"
            + m_name;
        m_remoteNAM->get(QNetworkRequest(QUrl(url)));
        settings.setValue("remoteName", m_name);
    }
}

void Remote::updateInfo()
{
    if (!m_name.isEmpty()) {
        if (!m_infoNAM) {
            m_infoNAM = new QNetworkAccessManager(this);
            connect(m_infoNAM, SIGNAL(finished(QNetworkReply*)),
                    this, SLOT(infoRequestFinished(QNetworkReply *)));
        }
        QSettings settings(this);
        QString url = settings.value("baseUrl",
            "http://mercury.wipsl.com/irwi/").toString()
            + "vote/get?name="
            + m_name;
        m_infoNAM->get(QNetworkRequest(QUrl(url)));
    }
}

void Remote::sendRating(Rating::Rating r)
{
    if (!m_name.isEmpty()) {
        if (!m_ratingNAM) {
            m_ratingNAM = new QNetworkAccessManager(this);
        }
        QSettings settings(this);
        m_ratingNAM->get(QNetworkRequest(QUrl(
            settings.value("baseUrl",
                "http://mercury.wipsl.com/irwi/").toString() 
            + "vote/"
            + ((r == Rating::Up) ? "up" : "down")
            + "?name=" 
            + m_name)));
   }
}

void Remote::remoteDownloadFinished(QNetworkReply *reply)
{
    if (reply->error() == QNetworkReply::NoError) {
        QFile file(QSettings(this).value("lircConf",
            "/etc/lircd.conf").toString());
        if(file.open(QIODevice::WriteOnly)) {
            file.write(reply->readAll());
            file.close();
        }
    }
    reply->close();
    reply->deleteLater();

    std::system("sudo /etc/init.d/lirc reload");

    emit saveFinished();
}

void Remote::infoRequestFinished(QNetworkReply *reply)
{
    if (reply->error() == QNetworkReply::NoError) {
        m_rating    = QString(reply->readLine(20)).toInt();
        m_voteCount = QString(reply->readLine(20)).toInt();
        m_mfg       = QString(reply->readLine(20));
    }
    reply->close();
    reply->deleteLater();

    emit infoUpdated();
}

