#ifndef _MAINWIDGET_H_
#define _MAINWIDGET_H_

#include <QWidget>
#include "irctrl.h"

class IEngine;
class QGridLayout;
class QToolButton;
class QSettings;

class MainWidget : public QWidget
{
    Q_OBJECT

public:
    MainWidget (QWidget *parent = NULL);
    ~MainWidget();

public slots:
    void showSettingsDialog();

private slots:
    void sendCmdVolUp();
    void sendCmdVolDown();
    void sendCmdChUp();
    void sendCmdChDown();
    void sendCmdPower();
    void sendCmdMute();

protected:
    void paintEvent(QPaintEvent *event);

private:
    void resize();

private:
    IrCtrl irCtrl;

    QSettings *settings;
    static const int BUTTON_COUNT = 6;
    QGridLayout *layout;
    QToolButton *buttons[BUTTON_COUNT];
};

#endif

