#include "settingsdlg.h"
#include "advsettingsdlg.h"
#include "selectremotedlg.h"
#include "aboutdlg.h"

#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QWidget>
#include <QDialog>
#include <QPushButton>
#include <QSettings>
#include <QLabel>

SettingsDlg::SettingsDlg(QWidget *parent)
    : QDialog(parent)
{
    layout = new QVBoxLayout(this);
    btnLayout = new QHBoxLayout(this);
    remoteNameLayout = new QHBoxLayout(this);
    
    QSettings settings(this);
    advSettingsBtn = new QPushButton(tr("Advanced"), this);
    selectRemoteBtn = new QPushButton(tr("Select remote"), this);
    aboutBtn = new QPushButton(tr("About"), this);

    btnLayout->addWidget(advSettingsBtn);
    btnLayout->addWidget(selectRemoteBtn);
    btnLayout->addWidget(aboutBtn);

    connect(advSettingsBtn, SIGNAL(clicked()),
            this, SLOT(showAdvSettingsDlg()));
    connect(selectRemoteBtn, SIGNAL(clicked()),
            this, SLOT(showSelectRemoteDlg()));
    connect(aboutBtn, SIGNAL(clicked()),
            this, SLOT(showAboutDlg()));

    remoteNameLabel = new QLabel(
                settings.value("remoteName", 
                tr("<no remote selected>")).toString(), this);
    remoteNameLayout->addWidget(new QLabel(tr("Remote name: "), this));
    remoteNameLayout->addWidget(remoteNameLabel);

    layout->addLayout(remoteNameLayout);
    layout->addLayout(btnLayout);
    this->setLayout(layout);

    updateRemoteName();
}

SettingsDlg::~SettingsDlg()
{
    delete advSettingsBtn;
    delete selectRemoteBtn;
    delete aboutBtn;
    delete remoteNameLabel;
    delete remoteNameLayout;
    delete btnLayout;
    delete layout;
}

void SettingsDlg::showAdvSettingsDlg()
{
    AdvSettingsDlg dlg(this);
    dlg.exec();
}

void SettingsDlg::showSelectRemoteDlg()
{
    SelectRemoteDlg dlg(this);
    connect(&dlg, SIGNAL(remoteDownloaded()), 
            this, SLOT(updateRemoteName()));
    dlg.exec();
}

void SettingsDlg::showAboutDlg()
{
    AboutDlg dlg(this);
    dlg.exec();
}

void SettingsDlg::updateRemoteName()
{
    QSettings settings(this);
    remoteNameLabel->setText(settings.value("remoteName", 
                tr("Select remote")).toString());
}


