#ifndef SELECTREMOTEDLG_H
#define SELECTREMOTEDLG_H

#include <QDialog>
#include <QString>
#include <QMap>

class QHBoxLayout;
class QListWidget;
class QListWidgetItem;
class QSettings;
class QNetworkAccessManager;
class QNetworkReply;
class QWidget;
class QPushButton;
class QLabel;

class SelectRemoteDlg : public QDialog
{
    Q_OBJECT
public:
    SelectRemoteDlg(QWidget *parent = 0);
    ~SelectRemoteDlg();

signals:
    void remoteDownloaded();

private slots:
    void alphabetItemChanged(QListWidgetItem *current, QListWidgetItem *previous);
    
    void mfgItemChanged(QListWidgetItem *current, QListWidgetItem *previous);
    void mfgListDownloadFinished(QNetworkReply *reply);

    void modelListDownloadFinished(QNetworkReply *reply);

    void downloadRemote();
    void remoteDownloadFinished(QNetworkReply *reply);

private:
    QHBoxLayout *layout;
    QListWidget *alphabetList;
    QListWidget *mfgList;
    QListWidget *modelList;
    QSettings *settings;
    QNetworkAccessManager *mfgNetAM;
    QNetworkAccessManager *modelNetAM;
    QNetworkAccessManager *remoteNetAM;
    QMap<QString, QString> *deviceNameMap;
    QPushButton *downloadBtn;
    QLabel *remoteNameLabel;

    void beginDownload(const QString &url, QNetworkAccessManager *nam);
    void setBusy(bool busy = true);
};

#endif

