#include "mainwidget.h"

#include <QInputDialog>
#include <QPainter>
#include <QGridLayout>
#include <QToolButton>
#include <QSettings>

#include "settingsdlg.h"

MainWidget::MainWidget (QWidget *parent)
    : QWidget(parent)
{
    layout = new QGridLayout(this);

    settings = new QSettings(this);

    char iconNames[][128] = {
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel4.png",
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volumelevel1.png",
        "/usr/share/icons/hicolor/48x48/hildon/rss_reader_move_up.png",
        "/usr/share/icons/hicolor/48x48/hildon/rss_reader_move_down.png",
        "/usr/share/icons/hicolor/48x48/hildon/location_applet_on.png",
        "/usr/share/icons/hicolor/48x48/hildon/statusarea_volume_mute.png"
    };

    for (int i = 0; i < BUTTON_COUNT; ++i)
    {
        QToolButton *button = new QToolButton(this);
        button->setIcon(QIcon(QString(
            settings->value(QString("buttonIcon") + QString::number(i),
                iconNames[i]).toString()))); 
        buttons[i] = button;
        button->setSizePolicy(QSizePolicy::MinimumExpanding,
                QSizePolicy::MinimumExpanding);
        layout->addWidget(button, i%2, i/2);
    }

    connect(buttons[0], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd0()));
    connect(buttons[1], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd1()));
    connect(buttons[2], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd2()));
    connect(buttons[3], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd3()));
    connect(buttons[4], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd4()));
    connect(buttons[5], SIGNAL(clicked()), &irCtrl, SLOT(sendCmd5()));

    this->setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    this->setLayout(layout);
    this->setAttribute(Qt::WA_TranslucentBackground);
    this->setAttribute(Qt::WA_OpaquePaintEvent);
    resize();
}

MainWidget::~MainWidget()
{
    delete settings;
}

void MainWidget::paintEvent(QPaintEvent*)
{
    int bgAlpha = settings->value("bgAlpha", "192").toInt();
    QPainter p(this);
    p.fillRect(rect(), QColor(0, 0, 0, bgAlpha));
    p.end();
}
 
void MainWidget::showSettingsDialog()
{
    SettingsDlg dlg;
    dlg.exec();
    update(); // Repaint required if bgAlpha value was changed
    resize();
}

void MainWidget::resize()
{
    int w = settings->value("width", "250").toInt();
    int h = settings->value("height", "148").toInt();
    if (w < 1)
        w = 250;
    if (h < 1)
        h = 148;
    QWidget::resize(w, h);
}

