#include <cstdlib>

#include <QTcpSocket>
#include <QHostAddress>
#include <QAbstractSocket>
#include <QSettings>

#include "irctrl_p.h"

IrCtrlPrivate::IrCtrlPrivate()
    : settings(NULL)
{
    settings = new QSettings();
    std::system("sudo /etc/init.d/lirc start");
}

IrCtrlPrivate::~IrCtrlPrivate()
{
    delete settings;
    settings = NULL;
    std::system("sudo /etc/init.d/lirc stop");
}

void IrCtrlPrivate::genericSendCmd(const QString &commandName)
{
    QTcpSocket sock;
    sock.setSocketOption(QAbstractSocket::LowDelayOption, 1);
    sock.connectToHost(QHostAddress::LocalHost, 
            settings->value("lircPort", LIRC_PORT).toInt(),
            QIODevice::WriteOnly|QIODevice::Unbuffered);
    sock.waitForConnected();
    QString remoteName =
        settings->value("remoteName", "REMOTE_NAME_MISSING").toString();
    QString cmd = "SEND_ONCE " + remoteName + " " + commandName + "\n";
    sock.write(cmd.toAscii());
    sock.waitForBytesWritten();
    sock.close();
}


