#include <QSettings>
#include "irctrl.h"
#include "irctrl_p.h"

IrCtrl::IrCtrl(QObject *parent)
    : QObject(parent)
    , d_ptr(new IrCtrlPrivate())
{
    Q_D(IrCtrl);
    d->q_ptr = this;
}

IrCtrl::IrCtrl(IrCtrlPrivate &dd, QObject *parent)
    : QObject(parent)
    , d_ptr(&dd)
{
    Q_D(IrCtrl);
    d->q_ptr = this;
}

IrCtrl::~IrCtrl()
{
    delete d_ptr;
}

void IrCtrl::sendCmd0()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd0", "VOL+").toString());
}

void IrCtrl::sendCmd1()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd1", "VOL-").toString());
}

void IrCtrl::sendCmd2()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd2", "P+").toString());
}

void IrCtrl::sendCmd3()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd3", "P-").toString());
}

void IrCtrl::sendCmd4()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd4", "ON/OFF").toString());
}

void IrCtrl::sendCmd5()
{
    Q_D(IrCtrl);
    d->genericSendCmd(d->settings->value("cmd5", "MUTE").toString());
}


