#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QSettings>
#include <QPushButton>
#include <QMessageBox>

#include "advsettingsdlg.h"
#include "settingstable.h"

AdvSettingsDlg::AdvSettingsDlg(QDialog *parent)
    : QDialog(parent)
    , layout(NULL)
    , btnLayout(NULL)
    , settings(NULL)
    , resetBtn(NULL)
    , saveBtn(NULL)
    , table(NULL)
{
    setWindowTitle(tr("Advanced settings"));
    setMinimumHeight(320);

    settings = new QSettings(this);

    // Set default values on first startup
    if (settings->allKeys().isEmpty())
        setDefaults();

    resetBtn = new QPushButton(tr("Defaults"), this);
    saveBtn = new QPushButton(tr("Save"), this);
    table = new SettingsTable(this);
    layout = new QHBoxLayout(this);
    btnLayout = new QVBoxLayout();

    connect(resetBtn, SIGNAL(clicked()), this, SLOT(showResetQuery()));
    connect(saveBtn, SIGNAL(clicked()), this, SLOT(save()));

    btnLayout->addWidget(resetBtn);
    btnLayout->addWidget(saveBtn);
    layout->addWidget(table, Qt::AlignLeft);
    layout->addLayout(btnLayout, 0);

    refreshList();
}

AdvSettingsDlg::~AdvSettingsDlg()
{
    delete layout;
    delete settings;
    delete resetBtn;
    delete saveBtn;
    delete table;
}

void AdvSettingsDlg::refreshList()
{
    table->removeAllRows();

    QStringList keys = settings->allKeys();
    for (int i = 0; i < keys.size(); ++i)
    {
        table->appendRow(keys.at(i),
            settings->value(keys.at(i), "n/a").toString());
    }
}

void AdvSettingsDlg::setDefaults()
{
    settings->setValue("lircPort", 8765);
    settings->setValue("remoteName", "No remote selected");
    settings->setValue("lircConf", "/etc/lircd.conf");
    settings->setValue("cmd0", "VOL+");
    settings->setValue("cmd1", "VOL-");
    settings->setValue("cmd2", "P+");
    settings->setValue("cmd3", "P-");
    settings->setValue("cmd4", "POWER");
    settings->setValue("cmd5", "MUTE");
    settings->setValue("remoteUrl",
        "http://mercury.wipsl.com/irwi/remotes/");
    settings->setValue("bgAlpha", 192);
    settings->setValue("height", 147);
    settings->setValue("width", 250);
}

void AdvSettingsDlg::showResetQuery()
{
    QMessageBox mbox(QMessageBox::Question, "",
        tr("Reset all settings to defaults?"),
        QMessageBox::Cancel | QMessageBox::Yes, this); 
    if (mbox.exec() == QMessageBox::Yes)
    {
        setDefaults();
        refreshList();
    }
}

void AdvSettingsDlg::save()
{
    for (int i = 0; i < table->rowCount(); ++i)
    {
        settings->setValue(table->key(i), table->value(i));
    }
    done(0); // close dialog
}



