/*
 *  Copyright (C) 2011 Javier S. Pedro
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef IRONCOPE_WIDGET_H
#define IRONCOPE_WIDGET_H

#include <libhildondesktop/libhildondesktop.h>

G_BEGIN_DECLS

#define IRONCOPE_TYPE_WIDGET              (ironcope_widget_get_type ())
#define IRONCOPE_WIDGET(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), IRONCOPE_TYPE_WIDGET, IroncopeWidget))
#define IRONCOPE_IS_WIDGET(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), IRONCOPE_TYPE_WIDGET))
#define IRONCOPE_WIDGET_CLASS(klass)      (G_TYPE_CHECK_CLASS_CAST ((klass), IRONCOPE_TYPE_WIDGET, IroncopeWidgetClass))
#define IRONCOPE_IS_WIDGET_CLASS(klass)   (G_TYPE_CHECK_CLASS_TYPE ((klass), IRONCOPE_TYPE_WIDGET))
#define IRONCOPE_WIDGET_GET_CLASS(obj)    (G_TYPE_INSTANCE_GET_CLASS ((obj), IRONCOPE_TYPE_WIDGET, IroncopeWidgetClass))

typedef struct _IroncopeWidget        IroncopeWidget;
typedef struct _IroncopeWidgetPrivate IroncopeWidgetPrivate;
typedef struct _IroncopeWidgetClass   IroncopeWidgetClass;

struct _IroncopeWidget
{
	HDHomePluginItem parent;
	IroncopeWidgetPrivate *priv;
};

struct _IroncopeWidgetClass
{
	HDHomePluginItemClass parent;
};

GType ironcope_widget_get_type(void) G_GNUC_CONST;
GtkWidget* ironcope_widget_new();

G_END_DECLS

#endif
