/**
 * intervalometer
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/osl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to tomi.suviola@gmail.com so I can send you a copy immediately.
 *
 * @copyright  Copyright (c) 2010 Tomi Suviola
 * @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */

#include <QtGui>
#include "irport.h"

QString IrPlugin::name()
{
    qDebug("name");
    qDebug("irport");
    return QString("irport");
}

void IrPlugin::open()
{
    qDebug("open");
    QSettings settings;
    //start lircd here
    QString lircd = QString("sudo" " /etc/init.d/lirc " "start");
    QProcess::execute(lircd);

    //get params for irsend
    QString remote = settings.value("ir/remote","CANON-RC1/RC5").toString();
    QString command = settings.value("ir/command","S").toString();
    settings.setValue("ir/remote", remote);
    settings.setValue("ir/command", command);

    //form command
    m_command = QString("/usr/bin/irsend "
                        "send_once") + " "
            + remote + " "
            + command;
}

void IrPlugin::close()
{
    qDebug("close");
    //TODO kill lircd here if we started it
}

void IrPlugin::shutter(const bool open)
{
    if (open) {
        qDebug("shutter: on");
        int res = QProcess::execute(m_command);
        if (res)
            qDebug() << "irsend failed:" << res;

    } else {
        qDebug("shutter: off");
    }
}

void IrPlugin::focus(const bool open)
{
    if (open)
        qDebug("focus: on");
    else
        qDebug("focus: off");
}

Q_EXPORT_PLUGIN2(irplugin, IrPlugin);
