#include "settings.h"
#include "ui_settings.h"

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);
    ui->scrollArea->setWidget(ui->widget);

    QSettings settings("internetradiowidget", "settings");
    alphaValue = settings.value("alphaValue", 150).toInt();
    showNotifications = settings.value("showNotifications", true).toBool();
    saveLog = settings.value("saveLog", true).toBool();
    url = settings.value("url", "http://87.117.203.226:8014").toString();
    icon = settings.value("icon", "lighticon").toString();
    showCustomString = settings.value("showCustomLabel", "false").toBool();
    customString = settings.value("customString", "Radio").toString();
    customLabelFontSize = settings.value("customLabelFontSize", 10).toInt();

    ui->customStringLineEdit->setText(customString);
    ui->customLabelFontSizeSpinBox->setValue(customLabelFontSize);
    ui->urlLineEdit->setText(url);
    QStringList iconsList;
    iconsList<<"lighticon"<<"blueicon"<<"lighticonsmall"<<"custom";
    ui->iconComboBox->addItems(iconsList);
    ui->iconComboBox->setCurrentIndex(ui->iconComboBox->findText(icon));
    QFile file("/home/user/MyDocs/.documents/InternetRadioWidgetStations.txt");
    QString string;
    QStringList list;
    QTextStream t(&file);
    if (file.open(QIODevice::ReadOnly | QIODevice::Text))
        {
            do
            {
                string = t.readLine();
                if (!string.isNull())
                {
                    list = string.split("-");
                    ui->stationsListComboBox->addItem(list.at(0));
                    stationsUrlsList.append(list.at(1));
                }
            } while (!string.isNull());
        }
    file.close();
    ui->showCustomStringCheckBox->setChecked(showCustomString);
    ui->showNotificationsCheckBox->setChecked(showNotifications);
    ui->saveLogCheckBox->setChecked(saveLog);
    ui->alphaValueSlider->setValue(alphaValue);
    ui->alphaValueLabel->setText(QString::number(alphaValue));


}

Settings::~Settings()
{
    delete ui;
}

void Settings::on_pickStationButton_clicked()
{
    QString string = stationsUrlsList.at(ui->stationsListComboBox->currentIndex());
    ui->urlLineEdit->setText(string);
}

void Settings::on_saveButton_clicked()
{
    alphaValue = ui->alphaValueSlider->value();
    showNotifications = ui->showNotificationsCheckBox->isChecked();
    saveLog = ui->saveLogCheckBox->isChecked();

    QSettings settings("internetradiowidget", "settings");
    settings.setValue("alphaValue", alphaValue);
    settings.setValue("showNotifications", showNotifications);
    settings.setValue("saveLog", saveLog);
    settings.setValue("url", ui->urlLineEdit->text());
    settings.setValue("icon", ui->iconComboBox->currentText());
    settings.setValue("showCustomLabel", ui->showCustomStringCheckBox->isChecked());
    settings.setValue("customString", ui->customStringLineEdit->text());
    settings.setValue("customLabelFontSize", ui->customLabelFontSizeSpinBox->value());

    emit saveButtonClicked();

    this->close();
}
