#include "mainwindow.h"

#include <QDebug>
#include <QVBoxLayout>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
{

    QFile radioFile( "/home/user/MyDocs/.documents/InternetRadioWidgetStations.txt" );

    if (radioFile.exists())
    {
        qDebug()<<"file exists";
    }
    else
    {
        qDebug()<<"file doesn't exist";
    radioFile.open((QIODevice::WriteOnly | QIODevice::Text | QIODevice::Append));
    QTextStream out(&radioFile);
    out<<"GoldenHitRadioItalia-http://87.117.203.226:8014"<<endl<<"RTL102.5-http://shoutcast.rtl.it:3010/"<<endl;
    }

    button = new QPushButton;
    button->setStyleSheet("QPushButton {border-width: 1px; border-color: transparent;border-bottom-right-radius: 8;border-top-left-radius: 8;border-top-right-radius: 8;border-bottom-left-radius: 8; background: transparent; color: #a6a6a6;} QPushButton:pressed {background-color: #5CB3FF;border-style: inset;border-color: #5CB3FF;}");

    widget = new QWidget;

    QVBoxLayout *mainLayout = new QVBoxLayout;
    customLabel = new QLabel;
    customLabel->setAlignment(Qt::AlignCenter);

    boolean = false;

    readSettings();

    infoBox = new QMaemo5InformationBox;
    label = new QLabel(infoBox);
    label->setFixedHeight(50);
    label->setAlignment(Qt::AlignCenter);
    infoBox->setWidget(label);


    setAttribute(Qt::WA_TranslucentBackground);


    running=false;

    connect(button, SIGNAL(clicked()), SLOT(buttonClicked()));



    mainLayout->addWidget(customLabel);
    mainLayout->addWidget(button);

    mainLayout->setMargin(0);
    mainLayout->setSpacing(0);

    widget->setLayout(mainLayout);


    setCentralWidget(widget);




}

MainWindow::~MainWindow()
{

}

void MainWindow::buttonClicked()
{
    qDebug()<<"button clicked";
    if (running==false)
    {
        qDebug()<<"starting stream";
        player = new QMediaPlayer;
        player->setMedia(QUrl(url));
        connect(player, SIGNAL(metaDataChanged()), SLOT(getMetaData()));
        button->setIcon(QIcon("/opt/internetradiowidget/" + icon + "/active.png"));
        player->play();

        running=true;
    }

    else
    {
        button->setIcon(QIcon("/opt/internetradiowidget/" + icon + "/inactive.png"));
        player->stop();
        delete player;
        running=false;
    }
}

void MainWindow::getMetaData()
  {
    if (showNotifications || saveLog)
    {
        QStringList extn_metadata = player->availableExtendedMetaData();
            int count_extn = extn_metadata.count();
            QString extn_metadata_key;
            QVariant extn_metadata_value;
            for( int indx = 0; indx < count_extn; indx++ )
              {
              extn_metadata_key = extn_metadata.at(indx);
              extn_metadata_value = player->extendedMetaData(extn_metadata_key);

              qDebug()<<"Key is: "<<extn_metadata_key;
              qDebug()<<"Value is: "<<extn_metadata_value.toString();

              if (extn_metadata_key=="title")
              {

                  if (showNotifications)
                  {
                      label->setText("Playing '" + extn_metadata_value.toString() + "'");
                      infoBox->show();
                  }

                  if (saveLog)
                  {
                      QFile file( "/home/user/MyDocs/.documents/InternetRadioWidgetLog.txt" );
                      file.open((QIODevice::WriteOnly | QIODevice::Text | QIODevice::Append));
                      QTextStream out(&file);
                      out<<QDateTime::currentDateTime().toString(Qt::ISODate)<<" "<<extn_metadata_value.toString()<<endl;
                  }
              }


              }
    }
  }

void MainWindow::showSettingsDialog()
{
    if (running==true) {
        buttonClicked();

    }

    settingsDialog = new Settings;
    settingsDialog->show();
    connect(settingsDialog, SIGNAL(saveButtonClicked()), SLOT(readSettings()));

}

void MainWindow::readSettings()
{
    QSettings settings("internetradiowidget", "settings");
    url = settings.value("url", "http://87.117.203.226:8014").toString();
    alphaValue = settings.value("alphaValue", 150).toInt();
    showNotifications = settings.value("showNotifications", true).toBool();
    showCustomLabel = settings.value("showCustomLabel", false).toBool();
    customString = settings.value("customString", "Radio").toString();
    saveLog = settings.value("saveLog", true).toBool();
    icon = settings.value("icon", "lighticon").toString();
    customLabelFontSize = settings.value("customLabelFontSize", 10).toInt();

    button->setMaximumSize(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size());
    button->setIcon(QIcon("/opt/internetradiowidget/" + icon + "/inactive.png"));
    button->setIconSize(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size());

    customLabel->setText(customString);
    customLabel->setFont(QFont("Nokia Sans", customLabelFontSize));
    customLabel->setMaximumWidth(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size().width());

    this->setMaximumSize(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size());
    widget->setMaximumSize(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size());

    if (showCustomLabel)
    {
        if (boolean) customLabel->show();
        boolean = true;
        this->setMaximumHeight(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size().height() + customLabel->size().height());
        widget->setMaximumHeight(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size().height() + customLabel->size().height());
    }
    else
    {
        customLabel->hide();
        widget->setMaximumHeight(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size().height());
        this->setMaximumHeight(QPixmap("/opt/internetradiowidget/" + icon + "/inactive.png").size().height());
    }

    repaint();
    adjustSize();




}
