#include "settingsdialog.h"


SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent)
{
    QSettings settings("internetradiowidget", "settings");
    alphaValue = settings.value("alphaValue", 150).toInt();
    showNotifications = settings.value("showNotifications", true).toBool();
    saveLog = settings.value("saveLog", true).toBool();
    url = settings.value("url", "http://87.117.203.226:8014").toString();
    icon = settings.value("icon", "lighticon").toString();

    QHBoxLayout *alphaValueLayout = new QHBoxLayout;
    QHBoxLayout *urlLayout = new QHBoxLayout;
    QHBoxLayout *iconLayout = new QHBoxLayout;
    QVBoxLayout *saveButtonLayout = new QVBoxLayout;
    QVBoxLayout *settingsButtosLayout = new QVBoxLayout;
    QHBoxLayout *mainLayout = new QHBoxLayout;

    urlLabel = new QLabel("Url:");
    urlLineEdit = new QLineEdit(url);

    urlLayout->addWidget(urlLabel);
    urlLayout->addWidget(urlLineEdit);

    iconLabel = new QLabel("Icon:");
    iconLabel->setMaximumWidth(80);
    iconComboBox = new QComboBox;
    QStringList iconsList;
    iconsList<<"lighticon"<<"blueicon"<<"lighticonsmall"<<"custom";
    iconComboBox->addItems(iconsList);
    iconComboBox->setCurrentIndex(iconComboBox->findText(icon));
    iconLayout->addWidget(iconLabel);
    iconLayout->addWidget(iconComboBox);

    saveButton = new QPushButton("Save");
    saveButton->setFixedWidth(200);

    connect(saveButton, SIGNAL(clicked()), SLOT(on_saveButton_clicked()));

    showNotificationsCheckBox = new QCheckBox("Show Notifications", this);
    showNotificationsCheckBox->setChecked(showNotifications);

    saveLogCheckBox = new QCheckBox("Save Log", this);
    saveLogCheckBox->setChecked(saveLog);

    QLabel *alphaValueNameValue = new QLabel("Alpha Value: ", this);
    alphaValueSlider = new QSlider;
    alphaValueLabel = new QLabel;
    alphaValueSlider->setOrientation(Qt::Horizontal);
    alphaValueSlider->setMinimum(0);
    alphaValueSlider->setMaximum(255);
    alphaValueSlider->setValue(alphaValue);
    alphaValueLabel->setText(QString::number(alphaValue));
    connect(alphaValueSlider, SIGNAL(valueChanged(int)), alphaValueLabel, SLOT(setNum(int)));

    alphaValueLayout->addWidget(alphaValueNameValue);
    alphaValueLayout->addWidget(alphaValueSlider);
    alphaValueLayout->addWidget(alphaValueLabel);
    alphaValueLayout->setMargin(0);

    settingsButtosLayout->addStretch();
    settingsButtosLayout->addLayout(urlLayout);
    settingsButtosLayout->addLayout(iconLayout);
    settingsButtosLayout->addLayout(alphaValueLayout);
    settingsButtosLayout->addWidget(showNotificationsCheckBox);
    settingsButtosLayout->addWidget(saveLogCheckBox);
    settingsButtosLayout->setMargin(2);

    saveButtonLayout->addStretch();
    saveButtonLayout->addWidget(saveButton);

    mainLayout->addLayout(settingsButtosLayout);
    mainLayout->addLayout(saveButtonLayout);


    setLayout(mainLayout);
    setWindowTitle("Settings");


}

void SettingsDialog::on_saveButton_clicked()
{
    alphaValue = alphaValueSlider->value();
    showNotifications = showNotificationsCheckBox->isChecked();
    saveLog = saveLogCheckBox->isChecked();

    QSettings settings("internetradiowidget", "settings");
    settings.setValue("alphaValue", alphaValue);
    settings.setValue("showNotifications", showNotifications);
    settings.setValue("saveLog", saveLog);
    settings.setValue("url", urlLineEdit->text());
    settings.setValue("icon", iconComboBox->currentText());

    emit saveButtonClicked();

    this->close();

}
