#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "bluetoothheadsetadapter.h"
#include "stationsdb.h"
#include "filterlistbydialog.h"
#include "lyricswebview.h"
#include "settingsdialog.h"

#include <QBuffer>
#include <QClipboard>
#include <QTime>
#include <QDebug>
#include <QFile>
#include <QHttp>
#include <QInputDialog>
#include <QLabel>
#include <QListWidgetItem>
#include <QtMaemo5>
#include <QtMaemo5/QMaemo5InformationBox>
#include <QtMultimediaKit/QMediaPlayer>
#include <QMessageBox>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QSettings>
#include <QTimer>
#include <QXmlStreamReader>


namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "it.ggiovanni.internetradioplayer")

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

public slots:
    Q_SCRIPTABLE int top_application();

private slots:
    void on_playButton_clicked();
    void getMetaData();
    void imageLoaded(int requestId, bool);
    void onRequestFinished(QNetworkReply *reply);
    void filterList(int type, QString filter, int orderBy);
    void on_playingNowButton_clicked();
    void on_lyricsButton_clicked();
    void on_stationsButton_clicked();
    void on_cronologyButton_clicked();
    void on_stopButton_clicked();
    void on_actionAbout_triggered();
    void on_addStationButton_clicked();
    void on_editStationButton_clicked();
    void on_removeStationButton_clicked();
    void on_stationsList_itemClicked(QListWidgetItem *item);
    void on_actionToggleFullscreen_triggered();
    void on_previousButton_clicked();
    void on_nextButton_clicked();
    void on_actionAbout_Qt_triggered();
    void on_stationsList_customContextMenuRequested(const QPoint &pos);
    void on_actionClearList_triggered();
    void on_actionRestoreDefaultList_triggered();
    void on_artistLineEdit_returnPressed();
    void on_titleLineEdit_returnPressed();
    void on_actionFilterListByCountry_triggered();
    void toggleButtonPressed();
    void on_lyricsWebViewButton_clicked();
    void on_actionSettings_triggered();
    void on_actionQuit_triggered();
    void on_actionDoNotFilterOrderByName_triggered();
    void on_actionDoNotFilterOrderByGenre_triggered();
    void on_actionDoNotFilterOrderByCountry_triggered();
    void on_actionFilterListByGenre_triggered();
    void on_actionDeleteFromFavourites_triggered();
    void on_actionGetFavouriteList_triggered();
    void on_actionAddToFavourites_triggered();

private:
    Ui::MainWindow *ui;
    QMediaPlayer* mediaPlayer;
    QMaemo5InformationBox infoBox;
    QLabel labelBox;
    QStringList stationsList;

    bool hideWhenClosing;
    bool quitActionPressed;

    StationsDB stationsDb;
    BluetoothHeadsetAdapter bluetoothAdapter;

    LyricsWebView* lyricsWebView;

    QNetworkAccessManager *nam;
    int imageRequest;
    QByteArray bytes;
    QHttp *http;
    QBuffer *buffer;

    void setIcons();
    void loadImage(QString url);
    void updateLyrics();
    void appendCronology(QString);
    void populateList(QStringList);
    QStringList getDefaultList();
    void loadStationsList();
    void saveStationsList();
    void connectBluetoothControl();

    void closeEvent(QCloseEvent *event);


};

#endif // MAINWINDOW_H
