#include "stationsdb.h"

StationsDB::StationsDB()
{

}

QStringList StationsDB::getFullStationList()
{

    QSqlQuery query( db );
    query.exec("SELECT name, url, country, genre FROM stations ORDER BY name");

    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();
             QString genre = query.value(3).toString();

             stationsList<<QString("%1 (%2) (%3)--%4").arg(name).arg(country).arg(genre).arg(url);
    }


    return stationsList;

}

void StationsDB::checkDB()
{
    QFile db(QString("%1/.config/internetradioplayer/stations.db").arg(QDir::homePath()));
    if (db.exists())
    {
        qDebug()<<"Database file exists";
        return;
    }
    else
    {
        QDir configDir( QString("%1/.config/internetradioplayer").arg(QDir::homePath()) );

        if ( !configDir.exists() )
        {
            configDir.mkdir( QString("%1/.config/internetradioplayer").arg(QDir::homePath()) );
        }

        qDebug()<<"Database file does not exist";
        system("echo 'cp /opt/internetradioplayer/db/stations.db /home/user/.config/internetradioplayer' | root ");
        system("echo 'chown user /home/user/.config/internetradioplayer/stations.db' | root ");
        system("echo 'chmod +rw /home/user/.config/internetradioplayer/stations.db' | root ");
    }
}

void StationsDB::clearDB()
{

    QSqlQuery query( db );
    qDebug()<<query.exec("DELETE FROM stations");
    qDebug()<<query.lastError();

}

void StationsDB::initDB()
{
    db = QSqlDatabase::addDatabase("QSQLITE");
    QString path = QString("%1/.config/internetradioplayer/stations.db").arg(QDir::homePath());
    qDebug()<<path;
    db.setDatabaseName(path);
    db.open();
}

void StationsDB::restoreDefaultDB()
{
    system("echo 'cp /opt/internetradioplayer/db/stations.db /home/user/.config/internetradioplayer' | root ");
    system("echo 'chown user /home/user/.config/internetradioplayer/stations.db' | root ");
    system("echo 'chmod +rw /home/user/.config/internetradioplayer/stations.db' | root ");
}

QStringList StationsDB::getGenreList()
{
    QSqlQuery query( db );
    query.exec("SELECT DISTINCT genre FROM stations ORDER BY name");

    QStringList genreList;
    while (query.next())
    {
             genreList<<query.value(0).toString();
    }

    return genreList;
}

QStringList StationsDB::getCountryList()
{
    QSqlQuery query( db );
    query.exec("SELECT DISTINCT country FROM stations ORDER BY name");

    QStringList countryList;
    while (query.next())
    {
             countryList<<query.value(0).toString();
    }

    return countryList;
}

QStringList StationsDB::getListFilteredByGenre(QString filter)
{
    QSqlQuery query( db );
    query.exec(QString("SELECT name, url, country FROM stations WHERE genre='%1' ORDER BY name").arg(filter));

    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();

             stationsList<<QString("%1 (%2)--%3").arg(name).arg(country).arg(url);
    }


    return stationsList;
}

QStringList StationsDB::getListFilteredByCountry(QString filter)
{
    QSqlQuery query( db );
    query.exec(QString("SELECT name, url, country FROM stations WHERE country='%1' ORDER BY name").arg(filter));

    QStringList stationsList;
    while (query.next())
    {
             QString name = query.value(0).toString();
             QString url = query.value(1).toString();
             QString country = query.value(2).toString();

             stationsList<<QString("%1 (%2)--%3").arg(name).arg(country).arg(url);
    }


    return stationsList;
}

void StationsDB::insertStation(QString name, QString url, QString genre, QString country)
{
    QSqlQuery query( db );
    query.exec(QString("INSERT INTO stations (name, url, genre, country) VALUES ('%1', '%2', '%3', '%4')")
               .arg(name).arg(url).arg(genre).arg(country));
    qDebug()<<query.lastError()<<query.lastInsertId();
}

void StationsDB::deleteStation(QString url)
{
    QSqlQuery query( db );
    qDebug()<<query.exec( QString("DELETE FROM stations WHERE url='%1'").arg(url) );
    qDebug()<<query.lastError();
}

void StationsDB::updateStation(QString currentUrl, QString name, QString url, QString genre, QString country)
{
    QSqlQuery query( db );
    qDebug()<<query.exec( QString("UPDATE stations SET name='%1', url='%2', genre='%3', country='%4' WHERE url='%5'")
                          .arg(name).arg(url).arg(genre).arg(country).arg(currentUrl));
    qDebug()<<query.lastError();
}


