/*
  This source is part of the Illumination library
  Copyright (C) 2010  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Def/Props.h>

#include <Lum/Base/L10N.h>

#include <Lum/OS/Event.h>

namespace Lum {
  namespace Def {

    PropItem::PropItem()
    {
      // no code
    }

    PropItem::~PropItem()
    {
      // no code
    }

    PropBoolean::PropBoolean(const Boolean& boolean)
    : boolean(boolean)
    {
      // no code
    }

    const Boolean& PropBoolean::GetValue() const
    {
      return boolean;
    }

    PropNumber::PropNumber(const Number& number)
    : number(number)
    {
      // no code
    }

    const Number& PropNumber::GetValue() const
    {
      return number;
    }

    PropOneOfMany::PropOneOfMany(const OneOfMany& oneOfMany)
    : oneOfMany(oneOfMany)
    {
      // no code
    }

    const OneOfMany& PropOneOfMany::GetValue() const
    {
      return oneOfMany;
    }

    PropOneOfN::PropOneOfN(const OneOfN& oneOfN)
    : oneOfN(oneOfN)
    {
      // no code
    }

    const OneOfN& PropOneOfN::GetValue() const
    {
      return oneOfN;
    }

    PropGroup::PropGroup(PropGroup* parent, const Desc& description)
    : parent(parent),
    description(description)
    {
      // no code
    }

    PropGroup::PropGroup()
    : parent(NULL)
    {
      // no code
    }

    PropGroup::PropGroup(const PropGroup& other)
    {
      parent=NULL;
      description=other.description;

      for (std::list<PropItem*>::const_iterator prop=other.props.begin();
           prop!=other.props.end();
           ++prop) {
        if (dynamic_cast<PropBoolean*>(*prop)!=NULL) {
          props.push_back(new PropBoolean(*dynamic_cast<PropBoolean*>(*prop)));
        }
        else if (dynamic_cast<PropNumber*>(*prop)!=NULL) {
          props.push_back(new PropNumber(*dynamic_cast<PropNumber*>(*prop)));
        }
        else if (dynamic_cast<PropInterval*>(*prop)!=NULL) {
          props.push_back(new PropInterval(*dynamic_cast<PropInterval*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfMany*>(*prop)!=NULL) {
          props.push_back(new PropOneOfMany(*dynamic_cast<PropOneOfMany*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfN*>(*prop)!=NULL) {
          props.push_back(new PropOneOfN(*dynamic_cast<PropOneOfN*>(*prop)));
        }
        else if (dynamic_cast<PropGroup*>(*prop)!=NULL) {
          PropGroup *group=new PropGroup(*dynamic_cast<PropGroup*>(*prop));

          group->parent=this;

          props.push_back(group);
        }
        else {
          assert(false);
        }
      }
    }

    PropGroup::~PropGroup()
    {
      for (std::list<PropItem*>::iterator prop=props.begin();
           prop!=props.end();
           ++prop) {
        delete *prop;
      }
    }


    PropGroup* PropGroup::Boolean(const Def::Boolean& boolean)
    {
      props.push_back(new PropBoolean(boolean));

      return this;
    }

    PropGroup* PropGroup::Number(const Def::Number& number)
    {
      props.push_back(new PropNumber(number));

      return this;
    }

    PropGroup* PropGroup::Interval(const Desc& desc,
                                   const Def::Number& start,
                                   const Def::Number& end)
    {
      props.push_back(new PropInterval(desc,start,end));

      return this;
    }

    PropGroup* PropGroup::OneOfMany(const Def::OneOfMany& oneOfMany)
    {
      props.push_back(new PropOneOfMany(oneOfMany));

      return this;
    }

    PropGroup* PropGroup::OneOfN(const Def::OneOfN& oneOfN)
    {
      props.push_back(new PropOneOfN(oneOfN));

      return this;
    }

    PropGroup* PropGroup::Group(const Def::Desc& description)
    {
      PropGroup *group=new PropGroup(this,description);

      props.push_back(group);

      return group;
    }

    PropGroup* PropGroup::Group(const std::wstring& name)
    {
      PropGroup *group=new PropGroup(this,Desc(name));

      props.push_back(group);

      return group;
    }

    PropGroup* PropGroup::End()
    {
      return parent;
    }

    PropGroup* PropGroup::Append(PropGroup* group)
    {
      assert(group!=NULL);

      for (std::list<PropItem*>::const_iterator prop=group->props.begin();
           prop!=group->props.end();
           ++prop) {
        if (dynamic_cast<PropBoolean*>(*prop)!=NULL) {
          props.push_back(new PropBoolean(*dynamic_cast<PropBoolean*>(*prop)));
        }
        else if (dynamic_cast<PropNumber*>(*prop)!=NULL) {
          props.push_back(new PropNumber(*dynamic_cast<PropNumber*>(*prop)));
        }
        else if (dynamic_cast<PropInterval*>(*prop)!=NULL) {
          props.push_back(new PropInterval(*dynamic_cast<PropInterval*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfMany*>(*prop)!=NULL) {
          props.push_back(new PropOneOfMany(*dynamic_cast<PropOneOfMany*>(*prop)));
        }
        else if (dynamic_cast<PropOneOfN*>(*prop)!=NULL) {
          props.push_back(new PropOneOfN(*dynamic_cast<PropOneOfN*>(*prop)));
        }
        else if (dynamic_cast<PropGroup*>(*prop)!=NULL) {
          PropGroup *group=new PropGroup(*dynamic_cast<PropGroup*>(*prop));

          group->parent=this;

          props.push_back(group);
        }
        else {
          assert(false);
        }
      }

      return this;
    }

    const Desc& PropGroup::GetDesc() const
    {
      return description;
    }

    const std::list<PropItem*>& PropGroup::GetProps() const
    {
      return props;
    }

    PropGroup* PropGroup::Create()
    {
      return new PropGroup();
    }
  }
}
