#ifndef LUM_MODEL_ADJUSTMENT_H
#define LUM_MODEL_ADJUSTMENT_H

/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Base/Model.h>

#include <Lum/Model/Number.h>

namespace Lum {
  namespace Model {

    class LUMAPI Adjustment : public Base::Model
    {
    private:
      SizeTRef top;
      SizeTRef visible;
      SizeTRef total;
      size_t   stepSize;

    public:
      Adjustment();

      void On(bool notify=true);
      void Off();

      bool IsValid() const;
      size_t GetTop() const;
      size_t GetBottom() const;
      size_t GetVisible() const;
      size_t GetTotal() const;
      size_t IsCompletelyVisible() const;

      void Set(size_t top, size_t visible, size_t total);
      void SetInvalid();
      void SetTop(size_t top);
      void SetDimension(size_t visible, size_t total);

      SizeT* GetTopModel() const;
      SizeT* GetVisibleModel() const;
      SizeT* GetTotalModel() const;

      void IncTop();
      void IncTop(size_t stepSize);
      void DecTop();
      void DecTop(size_t stepSize);
      void PageBack();
      void PageForward();

      void MakeVisible(size_t pos);
      void CenterOn(size_t pos);
      void ShowFirstPage();
      void ShowLastPage();

      void SetStepSize(size_t stepSize);
      size_t GetStepSize() const;
    };

#if defined(LUM_INSTANTIATE_TEMPLATES)
    LUM_EXPTEMPL template class LUMAPI Base::Reference<Adjustment>;
#endif

    typedef Base::Reference<Adjustment> AdjustmentRef;
  }
}

#endif
