/*
  This source is part of the Illumination library
  Copyright (C) 2004  Tim Teulings

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
*/

#include <Lum/Dlg/About.h>

#include <Lum/Base/L10N.h>

#include <Lum/About.h>
#include <Lum/Panel.h>

namespace Lum {
  namespace Dlg {

    About::About()
    {
      SetExitAction(GetClosedAction());
    }

    About::~About()
    {
      // no code
    }

    Lum::Object* About::GetContent()
    {
      Lum::About  *about;


      about=new Lum::About();
      about->SetFlex(true,true);
      about->SetAppInfo(info);

      return about;
    }

    void About::GetActions(std::vector<Lum::Dlg::ActionInfo>& actions)
    {
      Lum::Dlg::ActionDialog::CreateActionInfosClose(actions,GetClosedAction());
    }

    void About::SetAppInfo(const Def::AppInfo& info)
    {
      this->info=info;
    }

    void About::Show(Dialog* parent, const Def::AppInfo& info)
    {
      Show(parent->GetWindow(),info);
    }

    void About::Show(OS::Window* parent, const Def::AppInfo& info)
    {
      About about;

      about.SetParent(parent);
      about.SetTitle(L"About...");
      about.SetAppInfo(info);

      if (about.Open()) {
        about.EventLoop();
        about.Close();
      }
    }
  }
}
