/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Desktop;
import java.awt.peer.DesktopPeer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;

public class XDesktopPeer
implements DesktopPeer {
    private static boolean nativeLibraryLoaded = false;

    static boolean isDesktopSupported() {
        return nativeLibraryLoaded;
    }

    public boolean isSupported(Desktop.Action type) {
        return type != Desktop.Action.PRINT && type != Desktop.Action.EDIT;
    }

    public void open(File file) throws IOException {
        try {
            this.launch(file.toURI());
        }
        catch (MalformedURLException e) {
            throw new IOException(file.toString());
        }
    }

    public void edit(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the EDIT action.");
    }

    public void print(File file) throws IOException {
        throw new UnsupportedOperationException("The current platform doesn't support the PRINT action.");
    }

    public void mail(URI uri) throws IOException {
        this.launch(uri);
    }

    public void browse(URI uri) throws IOException {
        this.launch(uri);
    }

    private void launch(URI uri) throws IOException {
        if (!nativeLibraryLoaded) {
            throw new IOException("Failed to load native libraries.");
        }
        byte[] uriByteArray = (uri.toString() + '\u0000').getBytes();
        boolean result = this.gnome_url_show(uriByteArray);
        if (!result) {
            throw new IOException("Failed to show URI:" + uri);
        }
    }

    private native boolean gnome_url_show(byte[] var1);

    private static native boolean init();

    static {
        nativeLibraryLoaded = XDesktopPeer.init();
    }
}

