/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.GraphicAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public final class ShapeGraphicAttribute
extends GraphicAttribute {
    private Shape fShape;
    private boolean fStroke;
    public static final boolean STROKE = true;
    public static final boolean FILL = false;
    private Rectangle2D fShapeBounds;

    public ShapeGraphicAttribute(Shape shape, int alignment, boolean stroke) {
        super(alignment);
        this.fShape = shape;
        this.fStroke = stroke;
        this.fShapeBounds = this.fShape.getBounds2D();
    }

    public float getAscent() {
        return (float)Math.max(0.0, -this.fShapeBounds.getMinY());
    }

    public float getDescent() {
        return (float)Math.max(0.0, this.fShapeBounds.getMaxY());
    }

    public float getAdvance() {
        return (float)Math.max(0.0, this.fShapeBounds.getMaxX());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics2D graphics, float x, float y) {
        graphics.translate((int)x, (int)y);
        try {
            if (this.fStroke) {
                graphics.draw(this.fShape);
            } else {
                graphics.fill(this.fShape);
            }
        }
        finally {
            graphics.translate(-((int)x), -((int)y));
        }
    }

    public Rectangle2D getBounds() {
        Rectangle2D.Float bounds = new Rectangle2D.Float();
        bounds.setRect(this.fShapeBounds);
        if (this.fStroke) {
            bounds.width += 1.0f;
            bounds.height += 1.0f;
        }
        return bounds;
    }

    public Shape getOutline(AffineTransform tx) {
        return tx == null ? this.fShape : tx.createTransformedShape(this.fShape);
    }

    public int hashCode() {
        return this.fShape.hashCode();
    }

    public boolean equals(Object rhs) {
        try {
            return this.equals((ShapeGraphicAttribute)rhs);
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public boolean equals(ShapeGraphicAttribute rhs) {
        if (rhs == null) {
            return false;
        }
        if (this == rhs) {
            return true;
        }
        if (this.fStroke != rhs.fStroke) {
            return false;
        }
        if (this.getAlignment() != rhs.getAlignment()) {
            return false;
        }
        return this.fShape.equals(rhs.fShape);
    }
}

