/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.snmp;

import com.sun.jmx.snmp.Enumerated;
import com.sun.jmx.snmp.SnmpInt;
import java.io.Serializable;
import java.util.Hashtable;

public class EnumRowStatus
extends Enumerated
implements Serializable {
    private static final long serialVersionUID = 8966519271130162420L;
    public static final int unspecified = 0;
    public static final int active = 1;
    public static final int notInService = 2;
    public static final int notReady = 3;
    public static final int createAndGo = 4;
    public static final int createAndWait = 5;
    public static final int destroy = 6;
    static final Hashtable<Integer, String> intTable = new Hashtable();
    static final Hashtable<String, Integer> stringTable = new Hashtable();

    public EnumRowStatus(int valueIndex) throws IllegalArgumentException {
        super(valueIndex);
    }

    public EnumRowStatus(Enumerated valueIndex) throws IllegalArgumentException {
        this(valueIndex.intValue());
    }

    public EnumRowStatus(long valueIndex) throws IllegalArgumentException {
        this((int)valueIndex);
    }

    public EnumRowStatus(Integer valueIndex) throws IllegalArgumentException {
        super(valueIndex);
    }

    public EnumRowStatus(Long valueIndex) throws IllegalArgumentException {
        this((long)valueIndex);
    }

    public EnumRowStatus() throws IllegalArgumentException {
        this(0);
    }

    public EnumRowStatus(String x) throws IllegalArgumentException {
        super(x);
    }

    public EnumRowStatus(SnmpInt valueIndex) throws IllegalArgumentException {
        this(valueIndex.intValue());
    }

    public SnmpInt toSnmpValue() throws IllegalArgumentException {
        if (this.value == 0) {
            throw new IllegalArgumentException("`unspecified' is not a valid SNMP value.");
        }
        return new SnmpInt(this.value);
    }

    public static boolean isValidValue(int value) {
        if (value < 0) {
            return false;
        }
        return value <= 6;
    }

    protected Hashtable getIntTable() {
        return EnumRowStatus.getRSIntTable();
    }

    protected Hashtable getStringTable() {
        return EnumRowStatus.getRSStringTable();
    }

    static final Hashtable getRSIntTable() {
        return intTable;
    }

    static final Hashtable getRSStringTable() {
        return stringTable;
    }

    static {
        intTable.put(new Integer(0), "unspecified");
        intTable.put(new Integer(3), "notReady");
        intTable.put(new Integer(6), "destroy");
        intTable.put(new Integer(2), "notInService");
        intTable.put(new Integer(5), "createAndWait");
        intTable.put(new Integer(1), "active");
        intTable.put(new Integer(4), "createAndGo");
        stringTable.put("unspecified", new Integer(0));
        stringTable.put("notReady", new Integer(3));
        stringTable.put("destroy", new Integer(6));
        stringTable.put("notInService", new Integer(2));
        stringTable.put("createAndWait", new Integer(5));
        stringTable.put("active", new Integer(1));
        stringTable.put("createAndGo", new Integer(4));
    }
}

