/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import sun.nio.ch.DatagramChannelImpl;
import sun.nio.ch.Net;
import sun.nio.ch.OptionAdaptor;
import sun.nio.ch.Util;

public class DatagramSocketAdaptor
extends DatagramSocket {
    private final DatagramChannelImpl dc;
    private volatile OptionAdaptor opts = null;
    private volatile int timeout = 0;
    private volatile int trafficClass = 0;
    private static final DatagramSocketImpl dummyDatagramSocket = new DatagramSocketImpl(){

        protected void create() throws SocketException {
        }

        protected void bind(int lport, InetAddress laddr) throws SocketException {
        }

        protected void send(DatagramPacket p) throws IOException {
        }

        protected int peek(InetAddress i) throws IOException {
            return 0;
        }

        protected int peekData(DatagramPacket p) throws IOException {
            return 0;
        }

        protected void receive(DatagramPacket p) throws IOException {
        }

        protected void setTTL(byte ttl) throws IOException {
        }

        protected byte getTTL() throws IOException {
            return 0;
        }

        protected void setTimeToLive(int ttl) throws IOException {
        }

        protected int getTimeToLive() throws IOException {
            return 0;
        }

        protected void join(InetAddress inetaddr) throws IOException {
        }

        protected void leave(InetAddress inetaddr) throws IOException {
        }

        protected void joinGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        }

        protected void leaveGroup(SocketAddress mcastaddr, NetworkInterface netIf) throws IOException {
        }

        protected void close() {
        }

        public Object getOption(int optID) throws SocketException {
            return null;
        }

        public void setOption(int optID, Object value) throws SocketException {
        }
    };

    private DatagramSocketAdaptor(DatagramChannelImpl dc) throws IOException {
        super(dummyDatagramSocket);
        this.dc = dc;
    }

    public static DatagramSocket create(DatagramChannelImpl dc) {
        try {
            return new DatagramSocketAdaptor(dc);
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    private void connectInternal(SocketAddress remote) throws SocketException {
        InetSocketAddress isa = Net.asInetSocketAddress(remote);
        int port = isa.getPort();
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("connect: " + port);
        }
        if (remote == null) {
            throw new IllegalArgumentException("connect: null address");
        }
        if (!this.isClosed()) {
            return;
        }
        try {
            this.dc.connect(remote);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public void bind(SocketAddress local) throws SocketException {
        try {
            if (local == null) {
                local = new InetSocketAddress(0);
            }
            this.dc.bind(local);
        }
        catch (Exception x) {
            Net.translateToSocketException(x);
        }
    }

    public void connect(InetAddress address, int port) {
        try {
            this.connectInternal(new InetSocketAddress(address, port));
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    public void connect(SocketAddress remote) throws SocketException {
        if (remote == null) {
            throw new IllegalArgumentException("Address can't be null");
        }
        this.connectInternal(remote);
    }

    public void disconnect() {
        try {
            this.dc.disconnect();
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    public boolean isBound() {
        return this.dc.isBound();
    }

    public boolean isConnected() {
        return this.dc.isConnected();
    }

    public InetAddress getInetAddress() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getAddress() : null;
    }

    public int getPort() {
        return this.isConnected() ? Net.asInetSocketAddress(this.dc.remoteAddress()).getPort() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket p) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket = p;
                synchronized (datagramPacket) {
                    ByteBuffer bb = ByteBuffer.wrap(p.getData(), p.getOffset(), p.getLength());
                    if (this.dc.isConnected()) {
                        if (p.getAddress() == null) {
                            InetSocketAddress isa = (InetSocketAddress)this.dc.remoteAddress;
                            p.setPort(isa.getPort());
                            p.setAddress(isa.getAddress());
                            this.dc.write(bb);
                        } else {
                            this.dc.send(bb, p.getSocketAddress());
                        }
                    } else {
                        this.dc.send(bb, p.getSocketAddress());
                    }
                }
            }
            catch (IOException x) {
                Net.translateException(x);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void receive(ByteBuffer bb) throws IOException {
        Selector sel;
        SelectionKey sk;
        block14: {
            block13: {
                if (this.timeout == 0) {
                    this.dc.receive(bb);
                    return;
                }
                sk = null;
                sel = null;
                this.dc.configureBlocking(false);
                try {
                    long st;
                    if (this.dc.receive(bb) != null) {
                        Object var11_4 = null;
                        if (sk != null) {
                            sk.cancel();
                        }
                        break block13;
                    }
                    sel = Util.getTemporarySelector(this.dc);
                    sk = this.dc.register(sel, 1);
                    long to = this.timeout;
                    do {
                        if (!this.dc.isOpen()) {
                            throw new ClosedChannelException();
                        }
                        st = System.currentTimeMillis();
                        int ns = sel.select(to);
                        if (ns > 0 && sk.isReadable() && this.dc.receive(bb) != null) {
                            break block14;
                        }
                        sel.selectedKeys().remove(sk);
                    } while ((to -= System.currentTimeMillis() - st) > 0L);
                    throw new SocketTimeoutException();
                }
                catch (Throwable throwable) {
                    Object var11_6 = null;
                    if (sk != null) {
                        sk.cancel();
                    }
                    if (this.dc.isOpen()) {
                        this.dc.configureBlocking(true);
                    }
                    if (sel == null) throw throwable;
                    Util.releaseTemporarySelector(sel);
                    throw throwable;
                }
            }
            if (this.dc.isOpen()) {
                this.dc.configureBlocking(true);
            }
            if (sel == null) return;
            Util.releaseTemporarySelector(sel);
            return;
        }
        Object var11_5 = null;
        if (sk != null) {
            sk.cancel();
        }
        if (this.dc.isOpen()) {
            this.dc.configureBlocking(true);
        }
        if (sel == null) return;
        Util.releaseTemporarySelector(sel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receive(DatagramPacket p) throws IOException {
        Object object = this.dc.blockingLock();
        synchronized (object) {
            if (!this.dc.isBlocking()) {
                throw new IllegalBlockingModeException();
            }
            try {
                DatagramPacket datagramPacket = p;
                synchronized (datagramPacket) {
                    ByteBuffer bb = ByteBuffer.wrap(p.getData(), p.getOffset(), p.getLength());
                    this.receive(bb);
                    p.setLength(bb.position() - p.getOffset());
                }
            }
            catch (IOException x) {
                Net.translateException(x);
            }
        }
    }

    public InetAddress getLocalAddress() {
        if (this.isClosed()) {
            return null;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getAddress();
        }
        catch (Exception x) {
            return new InetSocketAddress(0).getAddress();
        }
    }

    public int getLocalPort() {
        if (this.isClosed()) {
            return -1;
        }
        try {
            return Net.asInetSocketAddress(this.dc.localAddress()).getPort();
        }
        catch (Exception x) {
            return 0;
        }
    }

    public void setSoTimeout(int timeout) throws SocketException {
        this.timeout = timeout;
    }

    public int getSoTimeout() throws SocketException {
        return this.timeout;
    }

    private OptionAdaptor opts() {
        if (this.opts == null) {
            this.opts = new OptionAdaptor(this.dc);
        }
        return this.opts;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.opts().setSendBufferSize(size);
    }

    public int getSendBufferSize() throws SocketException {
        return this.opts().getSendBufferSize();
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.opts().setReceiveBufferSize(size);
    }

    public int getReceiveBufferSize() throws SocketException {
        return this.opts().getReceiveBufferSize();
    }

    public void setReuseAddress(boolean on) throws SocketException {
        this.opts().setReuseAddress(on);
    }

    public boolean getReuseAddress() throws SocketException {
        return this.opts().getReuseAddress();
    }

    public void setBroadcast(boolean on) throws SocketException {
        this.opts().setBroadcast(on);
    }

    public boolean getBroadcast() throws SocketException {
        return this.opts().getBroadcast();
    }

    public void setTrafficClass(int tc) throws SocketException {
        this.opts().setTrafficClass(tc);
        this.trafficClass = tc;
    }

    public int getTrafficClass() throws SocketException {
        int tc = this.opts().getTrafficClass();
        if (tc < 0) {
            tc = this.trafficClass;
        }
        return tc;
    }

    public void close() {
        try {
            this.dc.close();
        }
        catch (IOException x) {
            throw new Error(x);
        }
    }

    public boolean isClosed() {
        return !this.dc.isOpen();
    }

    public DatagramChannel getChannel() {
        return this.dc;
    }
}

