/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteASCII
extends CharToByteConverter {
    private char highHalfZoneCode;

    public String getCharacterEncoding() {
        return "ASCII";
    }

    public int flush(byte[] output, int outStart, int outEnd) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.highHalfZoneCode = '\u0000';
            throw new MalformedInputException("String ends with <High Half Zone code> of UTF16");
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int convert(char[] input, int inOff, int inEnd, byte[] output, int outOff, int outEnd) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        byte[] tmpArray = new byte[1];
        this.charOff = inOff;
        this.byteOff = outOff;
        if (this.highHalfZoneCode != '\u0000') {
            char inputChar = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (input[inOff] >= '\udc00' && input[inOff] <= '\udfff') {
                this.badInputLength = 1;
                throw new UnknownCharacterException();
            }
            this.badInputLength = 0;
            throw new MalformedInputException("Previous converted string ends with <High Half Zone Code> of UTF16 , but this string is not begin with <Low Half Zone>");
        }
        while (this.charOff < inEnd) {
            int inputSize;
            int outputSize;
            byte[] outputByte;
            block14: {
                outputByte = tmpArray;
                char inputChar = input[this.charOff];
                outputSize = 1;
                inputSize = 1;
                if (inputChar >= '\ud800' && inputChar <= '\udbff') {
                    if (this.charOff + 1 == inEnd) {
                        this.highHalfZoneCode = inputChar;
                        return this.byteOff - outOff;
                    }
                    inputChar = input[this.charOff + 1];
                    if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                        if (!this.subMode) {
                            this.badInputLength = 2;
                            throw new UnknownCharacterException();
                        }
                        outputByte = this.subBytes;
                        outputSize = this.subBytes.length;
                        inputSize = 2;
                        break block14;
                    } else {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                }
                if (inputChar >= '\udc00' && inputChar <= '\udfff') {
                    this.badInputLength = 1;
                    throw new MalformedInputException();
                }
                if (inputChar <= '\u007f') {
                    outputByte[0] = (byte)inputChar;
                } else {
                    if (!this.subMode) {
                        this.badInputLength = 1;
                        throw new UnknownCharacterException();
                    }
                    outputByte = this.subBytes;
                    outputSize = this.subBytes.length;
                }
            }
            if (this.byteOff + outputSize > outEnd) {
                throw new ConversionBufferFullException();
            }
            for (int i = 0; i < outputSize; ++i) {
                output[this.byteOff++] = outputByte[i];
            }
            this.charOff += inputSize;
        }
        return this.byteOff - outOff;
    }

    public boolean canConvert(char ch) {
        return ch <= '\u007f';
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public int getMaxBytesPerChar() {
        return 1;
    }
}

