/*
 * Decompiled with CFR 0.152.
 */
package sun.applet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import sun.applet.AppContextCreator;
import sun.applet.AppletMessageHandler;
import sun.applet.AppletThreadGroup;
import sun.awt.AppContext;
import sun.net.www.ParseUtil;

public class AppletClassLoader
extends URLClassLoader {
    private URL base;
    private CodeSource codesource;
    private AccessControlContext acc;
    private boolean exceptionStatus = false;
    private final Object threadGroupSynchronizer = new Object();
    private final Object grabReleaseSynchronizer = new Object();
    private boolean codebaseLookup = true;
    private Object syncResourceAsStream = new Object();
    private Object syncResourceAsStreamFromJar = new Object();
    private boolean resourceAsStreamInCall = false;
    private boolean resourceAsStreamFromJarInCall = false;
    private AppletThreadGroup threadGroup;
    private AppContext appContext;
    int usageCount = 0;
    private HashMap jdk11AppletInfo = new HashMap();
    private HashMap jdk12AppletInfo = new HashMap();
    private static AppletMessageHandler mh = new AppletMessageHandler("appletclassloader");

    protected AppletClassLoader(URL base) {
        super(new URL[0]);
        this.base = base;
        this.codesource = new CodeSource(base, (Certificate[])null);
        this.acc = AccessController.getContext();
    }

    void setCodebaseLookup(boolean codebaseLookup) {
        this.codebaseLookup = codebaseLookup;
    }

    URL getBaseURL() {
        return this.base;
    }

    public URL[] getURLs() {
        URL[] jars = super.getURLs();
        URL[] urls = new URL[jars.length + 1];
        System.arraycopy(jars, 0, urls, 0, jars.length);
        urls[urls.length - 1] = this.base;
        return urls;
    }

    protected void addJar(String name) throws IOException {
        URL url;
        try {
            url = new URL(this.base, name);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("name");
        }
        this.addURL(url);
    }

    public synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        SecurityManager sm;
        int i = name.lastIndexOf(46);
        if (i != -1 && (sm = System.getSecurityManager()) != null) {
            sm.checkPackageAccess(name.substring(0, i));
        }
        try {
            return super.loadClass(name, resolve);
        }
        catch (ClassNotFoundException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        int index = name.indexOf(";");
        String cookie = "";
        if (index != -1) {
            cookie = name.substring(index, name.length());
            name = name.substring(0, index);
        }
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            if (!this.codebaseLookup) {
                throw new ClassNotFoundException(name);
            }
            String encodedName = ParseUtil.encodePath(name.replace('.', '/'), false);
            final String path = new StringBuffer(encodedName).append(".class").append(cookie).toString();
            try {
                byte[] b = (byte[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws IOException {
                        return AppletClassLoader.getBytes(new URL(AppletClassLoader.this.base, path));
                    }
                }, this.acc);
                if (b != null) {
                    return this.defineClass(name, b, 0, b.length, this.codesource);
                }
                throw new ClassNotFoundException(name);
            }
            catch (PrivilegedActionException e2) {
                throw new ClassNotFoundException(name, e2.getException());
            }
        }
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        Permission p;
        final PermissionCollection perms = super.getPermissions(codesource);
        URL url = codesource.getLocation();
        String path = null;
        try {
            p = url.openConnection().getPermission();
        }
        catch (IOException ioe) {
            p = null;
        }
        if (p instanceof FilePermission) {
            path = p.getName();
        } else if (p == null && url.getProtocol().equals("file")) {
            path = url.getFile().replace('/', File.separatorChar);
            path = ParseUtil.decode(path);
        }
        if (path != null) {
            Permission bperm;
            int endIndex;
            if (!path.endsWith(File.separator) && (endIndex = path.lastIndexOf(File.separatorChar)) != -1) {
                path = path.substring(0, endIndex + 1) + "-";
                perms.add(new FilePermission(path, "read"));
            }
            perms.add(new SocketPermission("localhost", "connect,accept"));
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        String host = InetAddress.getLocalHost().getHostName();
                        perms.add(new SocketPermission(host, "connect,accept"));
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            try {
                bperm = this.base.openConnection().getPermission();
            }
            catch (IOException ioe) {
                bperm = null;
            }
            if (bperm instanceof FilePermission) {
                String bpath = bperm.getName();
                if (bpath.endsWith(File.separator)) {
                    bpath = bpath + "-";
                }
                perms.add(new FilePermission(bpath, "read"));
            } else if (bperm == null && this.base.getProtocol().equals("file")) {
                String bpath = this.base.getFile().replace('/', File.separatorChar);
                if ((bpath = ParseUtil.decode(bpath)).endsWith(File.separator)) {
                    bpath = bpath + "-";
                }
                perms.add(new FilePermission(bpath, "read"));
            }
        }
        return perms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(URL url) throws IOException {
        byte[] b;
        HttpURLConnection huc;
        int code;
        URLConnection uc = url.openConnection();
        if (uc instanceof HttpURLConnection && (code = (huc = (HttpURLConnection)uc).getResponseCode()) >= 400) {
            throw new IOException("open HTTP connection failed.");
        }
        BufferedInputStream in = new BufferedInputStream(uc.getInputStream());
        try {
            int len;
            if (len != -1) {
                int n;
                b = new byte[len];
                for (len = uc.getContentLength(); len > 0; len -= n) {
                    n = ((InputStream)in).read(b, b.length - len, len);
                    if (n != -1) continue;
                    throw new IOException("unexpected EOF");
                }
            } else {
                byte[] tmp;
                b = new byte[8192];
                int total = 0;
                while ((len = ((InputStream)in).read(b, total, b.length - total)) != -1) {
                    if ((total += len) < b.length) continue;
                    tmp = new byte[total * 2];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
                if (total != b.length) {
                    tmp = new byte[total];
                    System.arraycopy(b, 0, tmp, 0, total);
                    b = tmp;
                }
            }
        }
        finally {
            ((InputStream)in).close();
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            InputStream is = null;
            Object object = this.syncResourceAsStream;
            synchronized (object) {
                this.resourceAsStreamInCall = true;
                is = super.getResourceAsStream(name);
                this.resourceAsStreamInCall = false;
            }
            if (this.codebaseLookup && is == null) {
                URL url = new URL(this.base, ParseUtil.encodePath(name, false));
                is = url.openStream();
            }
            return is;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStreamFromJar(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        try {
            InputStream is = null;
            Object object = this.syncResourceAsStreamFromJar;
            synchronized (object) {
                this.resourceAsStreamFromJarInCall = true;
                is = super.getResourceAsStream(name);
                this.resourceAsStreamFromJarInCall = false;
            }
            return is;
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findResource(String name) {
        URL url = super.findResource(name);
        if (name.startsWith("META-INF/")) {
            return url;
        }
        if (!this.codebaseLookup) {
            return url;
        }
        if (url == null) {
            boolean insideGetResourceAsStreamFromJar = false;
            Object object = this.syncResourceAsStreamFromJar;
            synchronized (object) {
                insideGetResourceAsStreamFromJar = this.resourceAsStreamFromJarInCall;
            }
            if (insideGetResourceAsStreamFromJar) {
                return null;
            }
            boolean insideGetResourceAsStream = false;
            Object object2 = this.syncResourceAsStream;
            synchronized (object2) {
                insideGetResourceAsStream = this.resourceAsStreamInCall;
            }
            if (!insideGetResourceAsStream) {
                try {
                    url = new URL(this.base, ParseUtil.encodePath(name, false));
                    if (!this.resourceExists(url)) {
                        url = null;
                    }
                }
                catch (Exception e) {
                    url = null;
                }
            }
        }
        return url;
    }

    private boolean resourceExists(URL url) {
        boolean ok = true;
        try {
            URLConnection conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hconn = (HttpURLConnection)conn;
                hconn.setRequestMethod("HEAD");
                int code = hconn.getResponseCode();
                if (code == 200) {
                    return true;
                }
                if (code >= 400) {
                    return false;
                }
            } else {
                InputStream is = conn.getInputStream();
                is.close();
            }
        }
        catch (Exception ex) {
            ok = false;
        }
        return ok;
    }

    public Enumeration findResources(String name) throws IOException {
        final Enumeration<URL> e = super.findResources(name);
        if (name.startsWith("META-INF/")) {
            return e;
        }
        if (!this.codebaseLookup) {
            return e;
        }
        URL u = new URL(this.base, ParseUtil.encodePath(name, false));
        if (!this.resourceExists(u)) {
            u = null;
        }
        final URL url = u;
        return new Enumeration(){
            private boolean done;

            public Object nextElement() {
                if (!this.done) {
                    if (e.hasMoreElements()) {
                        return e.nextElement();
                    }
                    this.done = true;
                    if (url != null) {
                        return url;
                    }
                }
                throw new NoSuchElementException();
            }

            public boolean hasMoreElements() {
                return !this.done && (e.hasMoreElements() || url != null);
            }
        };
    }

    Class loadCode(String name) throws ClassNotFoundException {
        name = name.replace('/', '.');
        name = name.replace(File.separatorChar, '.');
        String cookie = null;
        int index = name.indexOf(";");
        if (index != -1) {
            cookie = name.substring(index, name.length());
            name = name.substring(0, index);
        }
        String fullName = name;
        if (name.endsWith(".class") || name.endsWith(".java")) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        try {
            if (cookie != null) {
                name = new StringBuffer(name).append(cookie).toString();
            }
            return this.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            if (cookie != null) {
                fullName = new StringBuffer(fullName).append(cookie).toString();
            }
            return this.loadClass(fullName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThreadGroup getThreadGroup() {
        Object object = this.threadGroupSynchronizer;
        synchronized (object) {
            if (this.threadGroup == null || this.threadGroup.isDestroyed()) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object run() {
                        AppletClassLoader.this.threadGroup = new AppletThreadGroup(AppletClassLoader.this.base + "-threadGroup");
                        AppContextCreator creatorThread = new AppContextCreator(AppletClassLoader.this.threadGroup);
                        creatorThread.setContextClassLoader(AppletClassLoader.this);
                        Object object = creatorThread.syncObject;
                        synchronized (object) {
                            creatorThread.start();
                            try {
                                creatorThread.syncObject.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            AppletClassLoader.this.appContext = creatorThread.appContext;
                        }
                        return null;
                    }
                });
            }
            return this.threadGroup;
        }
    }

    public AppContext getAppContext() {
        return this.appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void grab() {
        Object object = this.grabReleaseSynchronizer;
        synchronized (object) {
            ++this.usageCount;
        }
        this.getThreadGroup();
    }

    protected void setExceptionStatus() {
        this.exceptionStatus = true;
    }

    public boolean getExceptionStatus() {
        return this.exceptionStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        AppContext tempAppContext = null;
        Object object = this.grabReleaseSynchronizer;
        synchronized (object) {
            if (this.usageCount > 1) {
                --this.usageCount;
            } else {
                Object object2 = this.threadGroupSynchronizer;
                synchronized (object2) {
                    tempAppContext = this.appContext;
                    this.usageCount = 0;
                    this.appContext = null;
                    this.threadGroup = null;
                }
            }
        }
        if (tempAppContext != null) {
            try {
                tempAppContext.dispose();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
    }

    void setJDK11Target(Class clazz, boolean bool) {
        this.jdk11AppletInfo.put(clazz.toString(), bool);
    }

    void setJDK12Target(Class clazz, boolean bool) {
        this.jdk12AppletInfo.put(clazz.toString(), bool);
    }

    Boolean isJDK11Target(Class clazz) {
        return (Boolean)this.jdk11AppletInfo.get(clazz.toString());
    }

    Boolean isJDK12Target(Class clazz) {
        return (Boolean)this.jdk12AppletInfo.get(clazz.toString());
    }

    private static void printError(String name, Throwable e) {
        String s = null;
        if (e == null) {
            s = mh.getMessage("filenotfound", name);
        } else if (e instanceof IOException) {
            s = mh.getMessage("fileioexception", name);
        } else if (e instanceof ClassFormatError) {
            s = mh.getMessage("fileformat", name);
        } else if (e instanceof ThreadDeath) {
            s = mh.getMessage("filedeath", name);
        } else if (e instanceof Error) {
            s = mh.getMessage("fileerror", e.toString(), name);
        }
        if (s != null) {
            System.err.println(s);
        }
    }
}

