/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] context) {
        if (context.length == 0) {
            this.context = null;
        } else if (context.length == 1) {
            this.context = context[0] != null ? (ProtectionDomain[])context.clone() : null;
        } else {
            ArrayList<ProtectionDomain> v = new ArrayList<ProtectionDomain>(context.length);
            for (int i = 0; i < context.length; ++i) {
                if (context[i] == null || v.contains(context[i])) continue;
                v.add(context[i]);
            }
            this.context = new ProtectionDomain[v.size()];
            this.context = v.toArray(this.context);
        }
    }

    public AccessControlContext(AccessControlContext acc, DomainCombiner combiner) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
        }
        this.context = acc.context;
        this.combiner = combiner;
    }

    AccessControlContext(ProtectionDomain[] context, DomainCombiner combiner) {
        if (context != null) {
            this.context = (ProtectionDomain[])context.clone();
        }
        this.combiner = combiner;
    }

    AccessControlContext(ProtectionDomain[] context, boolean isPrivileged) {
        this.context = context;
        this.isPrivileged = isPrivileged;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    DomainCombiner getAssignedCombiner() {
        AccessControlContext acc = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        if (acc != null) {
            return acc.combiner;
        }
        return null;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.combiner;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        int i;
        boolean dumpDebug = false;
        if (perm == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            boolean bl = dumpDebug = !Debug.isOn("codebase=");
            if (!dumpDebug) {
                for (i = 0; this.context != null && i < this.context.length; ++i) {
                    if (this.context[i].getCodeSource() == null || this.context[i].getCodeSource().getLocation() == null || !Debug.isOn("codebase=" + this.context[i].getCodeSource().getLocation().toString())) continue;
                    dumpDebug = true;
                    break;
                }
            }
            if ((dumpDebug &= !Debug.isOn("permission=") || Debug.isOn("permission=" + perm.getClass().getCanonicalName())) && Debug.isOn("stack")) {
                Thread.currentThread();
                Thread.dumpStack();
            }
            if (dumpDebug && Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (i = 0; i < this.context.length; ++i) {
                        debug.println("domain " + i + " " + this.context[i]);
                    }
                }
            }
        }
        if (this.context == null) {
            return;
        }
        for (i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null || this.context[i].implies(perm)) continue;
            if (dumpDebug) {
                debug.println("access denied " + perm);
            }
            if (Debug.isOn("failure")) {
                if (!dumpDebug) {
                    debug.println("access denied " + perm);
                }
                Thread.currentThread();
                Thread.dumpStack();
                final ProtectionDomain pd = this.context[i];
                final Debug db = debug;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        db.println("domain that failed " + pd);
                        return null;
                    }
                });
            }
            throw new AccessControlException("access denied " + perm, perm);
        }
        if (dumpDebug) {
            debug.println("access allowed " + perm);
        }
    }

    AccessControlContext optimize() {
        boolean skipAssigned;
        AccessControlContext acc = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        boolean skipStack = this.context == null;
        boolean bl = skipAssigned = acc == null || acc.context == null;
        if (acc != null && acc.combiner != null) {
            return this.goCombiner(this.context, acc);
        }
        if (skipAssigned && skipStack) {
            return this;
        }
        if (skipStack) {
            return acc;
        }
        int slen = this.context.length;
        if (skipAssigned && slen <= 2) {
            return this;
        }
        if (slen == 1 && this.context[0] == acc.context[0]) {
            return acc;
        }
        int n = skipAssigned ? 0 : acc.context.length;
        ProtectionDomain[] pd = new ProtectionDomain[slen + n];
        if (!skipAssigned) {
            System.arraycopy(acc.context, 0, pd, 0, n);
        }
        block0: for (int i = 0; i < this.context.length; ++i) {
            ProtectionDomain sd = this.context[i];
            if (sd == null) continue;
            for (int j = 0; j < n; ++j) {
                if (sd == pd[j]) continue block0;
            }
            pd[n++] = sd;
        }
        if (n != pd.length) {
            if (!skipAssigned && n == acc.context.length) {
                return acc;
            }
            if (skipAssigned && n == slen) {
                return this;
            }
            ProtectionDomain[] tmp = new ProtectionDomain[n];
            System.arraycopy(pd, 0, tmp, 0, n);
            pd = tmp;
        }
        this.context = pd;
        this.combiner = null;
        this.isPrivileged = false;
        return this;
    }

    private AccessControlContext goCombiner(ProtectionDomain[] current, AccessControlContext assigned) {
        if (AccessControlContext.getDebug() != null) {
            debug.println("AccessControlContext invoking the Combiner");
        }
        ProtectionDomain[] combinedPds = assigned.combiner.combine(current, assigned.context);
        this.context = combinedPds;
        this.combiner = assigned.combiner;
        this.isPrivileged = false;
        return this;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext that = (AccessControlContext)obj;
        if (this.context == null) {
            return that.context == null;
        }
        if (that.context == null) {
            return false;
        }
        if (!this.containsAllPDs(that) || !that.containsAllPDs(this)) {
            return false;
        }
        if (this.combiner == null) {
            return that.combiner == null;
        }
        if (that.combiner == null) {
            return false;
        }
        return this.combiner.equals(that.combiner);
    }

    private boolean containsAllPDs(AccessControlContext that) {
        boolean match = false;
        for (int i = 0; i < this.context.length; ++i) {
            match = false;
            ProtectionDomain thisPd = this.context[i];
            if (thisPd == null) {
                for (int j = 0; j < that.context.length && !match; ++j) {
                    match = that.context[j] == null;
                }
            } else {
                Class<?> thisPdClass = thisPd.getClass();
                for (int j = 0; j < that.context.length && !match; ++j) {
                    ProtectionDomain thatPd = that.context[j];
                    match = thatPd != null && thisPdClass == thatPd.getClass() && thisPd.equals(thatPd);
                }
            }
            if (match) continue;
            return false;
        }
        return match;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.context == null) {
            return hashCode;
        }
        for (int i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null) continue;
            hashCode ^= this.context[i].hashCode();
        }
        return hashCode;
    }
}

