/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.Obj;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.naming.ldap.Control;
import javax.net.SocketFactory;

class ClientId {
    private final int version;
    private final String hostname;
    private final int port;
    private final String protocol;
    private final Control[] bindCtls;
    private final OutputStream trace;
    private final String socketFactory;
    private final int myHash;
    private final int ctlHash;
    private SocketFactory factory = null;
    private Method sockComparator = null;
    private boolean isDefaultSockFactory = false;
    public static final boolean debug = false;

    ClientId(int version, String hostname, int port, String protocol, Control[] bindCtls, OutputStream trace, String socketFactory) {
        this.version = version;
        this.hostname = hostname.toLowerCase();
        this.port = port;
        this.protocol = protocol;
        this.bindCtls = bindCtls != null ? (Control[])bindCtls.clone() : null;
        this.trace = trace;
        this.socketFactory = socketFactory;
        if (socketFactory != null && !socketFactory.equals("javax.net.ssl.SSLSocketFactory")) {
            try {
                Class socketFactoryClass = Obj.helper.loadClass(socketFactory);
                Class<?> objClass = Class.forName("java.lang.Object");
                this.sockComparator = socketFactoryClass.getMethod("compare", objClass, objClass);
                Method getDefault = socketFactoryClass.getMethod("getDefault", new Class[0]);
                this.factory = (SocketFactory)getDefault.invoke(null, new Object[0]);
            }
            catch (Exception e) {}
        } else {
            this.isDefaultSockFactory = true;
        }
        this.ctlHash = ClientId.hashCodeControls(bindCtls);
        this.myHash = version + port + (trace != null ? trace.hashCode() : 0) + (this.hostname != null ? this.hostname.hashCode() : 0) + (protocol != null ? protocol.hashCode() : 0) + this.ctlHash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ClientId)) {
            return false;
        }
        ClientId other = (ClientId)obj;
        return this.myHash == other.myHash && this.version == other.version && this.port == other.port && this.trace == other.trace && (this.hostname == other.hostname || this.hostname != null && this.hostname.equals(other.hostname)) && (this.protocol == other.protocol || this.protocol != null && this.protocol.equals(other.protocol)) && this.ctlHash == other.ctlHash && ClientId.equalsControls(this.bindCtls, other.bindCtls) && this.equalsSockFactory(other);
    }

    public int hashCode() {
        return this.myHash;
    }

    private static int hashCodeControls(Control[] c) {
        if (c == null) {
            return 0;
        }
        int code = 0;
        for (int i = 0; i < c.length; ++i) {
            code = code * 31 + c[i].getID().hashCode();
        }
        return code;
    }

    private static boolean equalsControls(Control[] a, Control[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i].getID().equals(b[i].getID()) && a[i].isCritical() == b[i].isCritical() && Arrays.equals(a[i].getEncodedValue(), b[i].getEncodedValue())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsSockFactory(ClientId other) {
        if (this.isDefaultSockFactory && other.isDefaultSockFactory) {
            return true;
        }
        if (!other.isDefaultSockFactory) {
            return this.invokeComparator(other, this);
        }
        return this.invokeComparator(this, other);
    }

    private boolean invokeComparator(ClientId c1, ClientId c2) {
        Object ret;
        try {
            ret = c1.sockComparator.invoke(c1.factory, c1.socketFactory, c2.socketFactory);
        }
        catch (Exception e) {
            return false;
        }
        return (Integer)ret == 0;
    }

    private static String toStringControls(Control[] ctls) {
        if (ctls == null) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        for (int i = 0; i < ctls.length; ++i) {
            str.append(ctls[i].getID());
            str.append(' ');
        }
        return str.toString();
    }

    public String toString() {
        return this.hostname + ":" + this.port + ":" + (this.protocol != null ? this.protocol : "") + ":" + ClientId.toStringControls(this.bindCtls) + ":" + this.socketFactory;
    }
}

