/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import sun.tools.jconsole.InternalDialog;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.LabeledComponent;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.Utilities;
import sun.tools.jconsole.VMInternalFrame;
import sun.tools.jconsole.VMPanel;
import sun.tools.jconsole.VariableGridLayout;

public class CreateMBeanDialog
extends InternalDialog
implements ActionListener {
    JConsole jConsole;
    JComboBox connections;
    JButton createMBeanButton;
    JButton unregisterMBeanButton;
    JButton cancelButton;
    private static final String HOTSPOT_MBEAN = "sun.management.HotspotInternal";
    private static final String HOTSPOT_MBEAN_OBJECTNAME = "sun.management:type=HotspotInternal";

    public CreateMBeanDialog(JConsole jConsole) {
        super(jConsole, "JConsole: Hotspot MBeans", true);
        this.jConsole = jConsole;
        Utilities.setAccessibleDescription(this, Resources.getText("Hotspot MBeans.dialog.accessibleDescription", new Object[0]));
        Container cp = this.getContentPane();
        ((JComponent)cp).setBorder(new EmptyBorder(10, 10, 4, 10));
        JPanel centerPanel = new JPanel(new VariableGridLayout(0, 1, 4, 4, false, true));
        cp.add((Component)centerPanel, "Center");
        this.connections = new JComboBox();
        this.updateConnections();
        centerPanel.add(new LabeledComponent(Resources.getText("Manage Hotspot MBeans in: ", new Object[0]), this.connections));
        JPanel bottomPanel = new JPanel(new BorderLayout());
        cp.add((Component)bottomPanel, "South");
        JPanel buttonPanel = new JPanel();
        bottomPanel.add((Component)buttonPanel, "North");
        this.createMBeanButton = new JButton(Resources.getText("Create", new Object[0]));
        buttonPanel.add(this.createMBeanButton);
        this.unregisterMBeanButton = new JButton(Resources.getText("Unregister", new Object[0]));
        buttonPanel.add(this.unregisterMBeanButton);
        this.cancelButton = new JButton(Resources.getText("Cancel", new Object[0]));
        buttonPanel.add(this.cancelButton);
        this.statusBar = new JLabel(" ", 0);
        bottomPanel.add((Component)this.statusBar, "South");
        this.createMBeanButton.addActionListener(this);
        this.unregisterMBeanButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        LabeledComponent.layout(centerPanel);
        this.pack();
        this.setLocationRelativeTo(jConsole);
    }

    private void updateConnections() {
        List<VMInternalFrame> frames = this.jConsole.getInternalFrames();
        TreeSet<ProxyClient> data = new TreeSet<ProxyClient>(new Comparator<ProxyClient>(){

            @Override
            public int compare(ProxyClient o1, ProxyClient o2) {
                return o1.connectionName().compareTo(o2.connectionName());
            }
        });
        if (frames.size() == 0) {
            VMPanel vmpanel;
            ProxyClient client;
            JComponent cp = (JComponent)this.jConsole.getContentPane();
            Component comp = ((BorderLayout)cp.getLayout()).getLayoutComponent("Center");
            if (comp instanceof VMPanel && (client = (vmpanel = (VMPanel)comp).getProxyClient(false)) != null && client.hasPlatformMXBeans()) {
                data.add(client);
            }
        } else {
            for (VMInternalFrame f : frames) {
                ProxyClient client = f.getVMPanel().getProxyClient(false);
                if (client == null || !client.hasPlatformMXBeans()) continue;
                data.add(client);
            }
        }
        this.connections.invalidate();
        this.connections.setModel(new DefaultComboBoxModel<Object>(data.toArray()));
        this.connections.validate();
    }

    public void actionPerformed(final ActionEvent ev) {
        this.setVisible(false);
        this.statusBar.setText("");
        if (ev.getSource() != this.cancelButton) {
            new Thread("CreateMBeanDialog.actionPerformed"){

                public void run() {
                    try {
                        Object buff = null;
                        Object c = CreateMBeanDialog.this.connections.getSelectedItem();
                        if (c == null) {
                            return;
                        }
                        if (ev.getSource() == CreateMBeanDialog.this.createMBeanButton) {
                            MBeanServerConnection connection = ((ProxyClient)c).getMBeanServerConnection();
                            connection.createMBean(CreateMBeanDialog.HOTSPOT_MBEAN, null);
                        } else if (ev.getSource() == CreateMBeanDialog.this.unregisterMBeanButton) {
                            MBeanServerConnection connection = ((ProxyClient)c).getMBeanServerConnection();
                            connection.unregisterMBean(new ObjectName(CreateMBeanDialog.HOTSPOT_MBEAN_OBJECTNAME));
                        }
                        return;
                    }
                    catch (InstanceAlreadyExistsException e) {
                        CreateMBeanDialog.this.statusBar.setText(Resources.getText("Error: MBeans already exist", new Object[0]));
                    }
                    catch (InstanceNotFoundException e) {
                        CreateMBeanDialog.this.statusBar.setText(Resources.getText("Error: MBeans do not exist", new Object[0]));
                    }
                    catch (Exception e) {
                        CreateMBeanDialog.this.statusBar.setText(e.toString());
                    }
                    CreateMBeanDialog.this.setVisible(true);
                }
            }.start();
        }
    }

    public void setVisible(boolean b) {
        boolean wasVisible = this.isVisible();
        if (b) {
            this.setLocationRelativeTo(this.jConsole);
            this.invalidate();
            this.updateConnections();
            this.validate();
            this.repaint();
        }
        super.setVisible(b);
        if (b && !wasVisible) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CreateMBeanDialog.this.connections.requestFocus();
                }
            });
        }
    }
}

