/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#include "cookiejar.h"

#include <QByteArray>
#include <QSettings>
#include <QUrl>

CookieJar::CookieJar(QObject *parent) :
        QNetworkCookieJar(parent) {

    loadConfig();
}

CookieJar::~CookieJar() {

    saveConfig();
}

void CookieJar::saveConfig() const {

    QList<QNetworkCookie> cookies = allCookies();

    QSettings settings;
    settings.beginWriteArray("Cookies/cookie");
    int i = 0;
    foreach (QNetworkCookie cookie, cookies) {
        if (cookie.isSessionCookie()) {
            continue;
        }
        QByteArray cookieString = cookie.toRawForm();
        settings.setArrayIndex(i);
        settings.setValue("content", cookieString);
        i++;
    }
    settings.endArray();
}

void CookieJar::loadConfig() {

    QList<QNetworkCookie> cookies;

    QSettings settings;
    int size = settings.beginReadArray("Cookies/cookie");
    for (int i = 0; i < size; i++) {
        settings.setArrayIndex(i);
        QByteArray cookieString = settings.value("content").toByteArray();
        QList<QNetworkCookie> cookieList = QNetworkCookie::parseCookies(cookieString);
        cookies += cookieList;
    }
    settings.endArray();

    setAllCookies(cookies);
}
