/****************************************************************************
**
** This file is part of the Hyves PhoneGap container.
** Copyright (C) 2010-2011 Hyves (Startphone Ltd.)
** http://www.hyves.nl
**
** This program is free software: you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation, either version 3 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program.  If not, see <http://www.gnu.org/licenses/>.
**
****************************************************************************/

#ifndef THUMBNAILNETWORKREPLY_H
#define THUMBNAILNETWORKREPLY_H

#include <QByteArray>
#include <QNetworkReply>
#include <QNetworkRequest>

#ifdef Q_OS_SYMBIAN
    #include "symbianpicloader.h"
#endif

class ThumbnailLoader;

/**
 * @class ThumbnailNetworkReply provides a fast way to load/generate thumbnails for local JPG images
 * from webkit.
 * Example url: "thumb:E:/images/file.jpg"
 */
#ifdef Q_OS_SYMBIAN
class ThumbnailNetworkReply : public QNetworkReply, public MSymbianPicLoader
#else
class ThumbnailNetworkReply : public QNetworkReply
#endif
{
    Q_OBJECT

    public:
        ThumbnailNetworkReply(const QNetworkRequest &request, QObject *parent = 0);
        virtual ~ThumbnailNetworkReply();

        virtual void abort();
        virtual qint64 bytesAvailable() const;

#ifdef Q_OS_SYMBIAN
        /**
         * @reimp from MSymbianPicLoader
         * Callback for exif preview
         */
        virtual void thumbLoaded(QPixmap);
#endif

    protected:
        virtual qint64 readData(char *data, qint64 maxLength);

    private slots:
        void thumbLoaded(const QByteArray& data);
        void failure();
        void success();

    private:
        Q_DISABLE_COPY(ThumbnailNetworkReply);
        ThumbnailNetworkReply();

#ifdef Q_OS_SYMBIAN
        SymbianPicLoader *m_exifLoader;
#endif
        ThumbnailLoader *m_loader;
        QByteArray m_imgData;
};

#endif // THUMBNAILNETWORKREPLY_H
