#ifndef DEBUGCONSOLE_H
#define DEBUGCONSOLE_H

#include <QObject>
#include <QQueue>
#include <QStringList>


class DebugConsole : public QObject {

    Q_OBJECT

    public:
        /**
         * DebugConsole uses the singleton pattern
         * @returns instance of the DebugConsole
         */
        static DebugConsole *instance();

        ~DebugConsole();

        /**
         * @returns the maximum number of lines being kept in the buffer
         */
        int maxLength() const;

        /**
         * Defines how many log messages are kept in the buffer
         * @param max maximum number of log messages
         */
        void setMaxLength(int max);

        Q_PROPERTY(int maxLength READ maxLength WRITE setMaxLength);

        Q_INVOKABLE void log(const QString &message);

        Q_INVOKABLE QStringList getLogMessages() const;

    private:
        DebugConsole(); // Singleton pattern, see DebugConsole::instance()
        Q_DISABLE_COPY(DebugConsole);

        int m_maxLength;
        QQueue<QString> m_logMessages;
};

#endif // DEBUGCONSOLE_H
