#ifndef DEVICEINFO_H
#define DEVICEINFO_H

#include <QObject>

class DeviceInfo : public QObject {

    Q_OBJECT

    /**
     * @returns "<manufacturer> <model> (<product name>)" of the device,
     * e.g. 'Nokia N8-00 (RM-596)'
     */
    Q_PROPERTY(QString name READ name)

    /**
     * @returns the device's operating system, e.g. 'Symbian' or 'Maemo'
     */
    Q_PROPERTY(QString platform READ platform)

    /**
     * @returns the device's International Mobile Equipment Identity (IMEI)
     * or a null string if not available
     */
    Q_PROPERTY(QString uuid READ uuid)

    /**
     * @returns returns the devices operating system version number, e.g. 'v9.4' or '^3'
     */
    Q_PROPERTY(QString version READ version)

    /**
     * @returns the container version number, e.g. 1.0.7
     */
    Q_PROPERTY(QString phonegapVersion READ phonegapVersion)

    public:
        explicit DeviceInfo(QObject *parent = 0);

        const QString &name() const;
        const QString &platform() const;
        const QString &uuid() const;
        const QString &version() const;
        QString phonegapVersion() const;

    private:
        QString m_name;
        QString m_platform;
        QString m_uuid;
        QString m_version;
};

#endif // DEVICEINFO_H
