#include "qwebviewselectionsuppressor.h"

#include <QMouseEvent>
#include <QWebView>
#include <QEvent>

QWebViewSelectionSuppressor::QWebViewSelectionSuppressor(QWebView *v) :
        QObject(v),
        view(v),
        enabled(false),
        mousePressed(false) {
    Q_ASSERT(view);
    enable();
}

void QWebViewSelectionSuppressor::enable() {

    if (enabled)
        return;
    view->installEventFilter(this);
    enabled = true;
}

void QWebViewSelectionSuppressor::disable() {

    if (!enabled)
        return;
    view->removeEventFilter(this);
    enabled = false;
}

bool QWebViewSelectionSuppressor::isEnabled() const {

    return enabled;
}

bool QWebViewSelectionSuppressor::eventFilter(QObject *, QEvent *e) {

    switch (e->type()) {
    case QEvent::MouseButtonPress:
        if (static_cast<QMouseEvent *>(e)->button() == Qt::LeftButton)
            mousePressed = true;
        break;
    case QEvent::MouseButtonRelease:
        if (static_cast<QMouseEvent *>(e)->button() == Qt::LeftButton)
            mousePressed = false;
        break;
    case QEvent::MouseMove:
        if (mousePressed)
            return true;
        break;
    default:
        break;
    }
    return false;
}

