

TEMPLATE	= app
TARGET  = hskiste
macx:TARGET= HsKiste
PRE_TARGETDEPS = hstart
; hskiste.depends += commono \
; 		hstarter

####begin: predependecies ##########
hstart_qmake.target = hsqm
hstart_qmake.commands = ${QMAKE} -makefile hstarter.pre -o Makefile.hstarter
hstart.target = hstart
hstart.commands = make -f Makefile.hstarter
win32:hstart.commands = mingw32-make -f Makefile.hstarter
hstart.depends = hstart_qmake
QMAKE_EXTRA_TARGETS += hstart hstart_qmake


; moccomo.target = ${OBJECTS_DIR}moc_common.o 
; QMAKE_EXTRA_TARGETS += moccomo

; commono.target = ${OBJECTS_DIR}common.o
; startero.target = ${OBJECTS_DIR}/starter.o
; startero.commands = ${CXX} -c  ${INCPATH}  src/starter.cpp -o ${OBJECTS_DIR}/starter.o
; QMAKE_EXTRA_TARGETS += commono startero moccomo


; hstarter.target = hstarter
; hstarter.commands = ${CXX} ${LFLAGS} ${LIBS} ${OBJECTS_DIR}/moc_common.o ${OBJECTS_DIR}/starter.o  ${OBJECTS_DIR}/common.o -o ${OBJECTS_DIR}/hstarter
; macx:hstarter.commands = (test -d build/HsKiste.app/Contents/MacOS/ || mkdir -p build/HsKiste.app/Contents/MacOS/) && \
; 	${CXX} -headerpad_max_install_names ${LFLAGS} ${LIBS} ${OBJECTS_DIR}moc_common.o ${OBJECTS_DIR}/starter.o  ${OBJECTS_DIR}/common.o -o ${OBJECTS_DIR}/HsKiste.app/Contents/MacOS/hstarter
; win32:hstarter.commands = ${CXX} -Wl,-subsystem,windows build\moc_common.o build\starter.o build\common.o -I"C:\Qt\2010.05\qt\include" -L"C:\Qt\2010.05\qt\lib" -lQtGui4 -lQtCore4 -o build\hstarter.exe
; hstarter.depends = commono startero moccomo
; QMAKE_EXTRA_TARGETS += hstarter
####end: predependencies ##########


# All generated files into one directory
DESTDIR	= build
OBJECTS_DIR = build
MOC_DIR	= build
UI_DIR	= build
VPATH	+= src uis
CONFIG	+= release
CONFIG	-= debug
QT	+= core gui declarative network
maemo5:QT	+=  maemo5


HEADERS	+= common.h \
		Listener.h \
		hsAddOn.h
SOURCES	+= main.cpp \
	common.cpp
FORMS	+= main.ui \
		about.ui \
		config.ui

win32{
FORMS	-= config.ui
FORMS	+= w_config.ui
}

maemo5 {
FORMS = 	m_main.ui \
		m_about.ui \
		m_config.ui \
		m_task.ui
}
TRANSLATIONS =	data/lang/hslang_en.ts
CODECFORTR =	 UTF-8


win32:RC_FILE = data/icon.rc
macx:ICON=data/HsKiste.icns
RESOURCES=hskiste.qrc



DEPENDPATH +=
INCLUDEPATH += src \ 
		build
LIBS	+=
DEFINES	+=

maemo5 {
LIBS	+= -lalarm
 }


### begin mac-deployment  and cleaning ######
macx{
; POST_TARGETDEPS += channels \
;  		macdeploy
channel.target	= channels
channel.commands	= (test -d build/HsKiste.app/Contents/Resources/ || mkdir -p build/HsKiste.app/Contents/Resources/) && \
		${COPY} data/channels ${OBJECTS_DIR}/HsKiste.app/Contents/Resources/channels
lang.target	= lang
lang.commands	= (test -d build/HsKiste.app/Contents/Resources/lang || mkdir -p build/HsKiste.app/Contents/Resources/lang) && \
		${COPY} data/lang/* ${OBJECTS_DIR}/HsKiste.app/Contents/Resources/lang/
		
addons.target	= addon
addons.commands	= (test -d build/HsKiste.app/Contents/addons || mkdir -p build/HsKiste.app/Contents/addons) && \
		${COPY} -R addons/* ${OBJECTS_DIR}/HsKiste.app/Contents/addons
		
nib.target = nib
nib.commands = (test -d build/HsKiste.app/Contents/Resources || mkdir -p build/HsKiste.app/Contents/Resources) && \
		${COPY} -R /opt/local/share/qt4/qt_menu.nib ${OBJECTS_DIR}/HsKiste.app/Contents/Resources/qt_menu.nib
; mdepl.target	= ${OBJECTS_DIR}/HsKiste.app/Contents/Resources/qt.conf
mdepl.target	= macdeploy
mdepl.commands	= cd ${OBJECTS_DIR} && macdeployqt HsKiste.app -dmg -verbose=2  && cd ..
mdepl.depends	= all channels lang addons nib
macclean.commands	= rm -rf build/HsKiste.app build/HsKiste.dmg
macclean.target	= macclean
compiler_clean.depends	+= macclean
QMAKE_EXTRA_TARGETS += channel mdepl macclean lang addons nib
}
### end mac-deployment and cleaning ######

### begin win32-deployment  and cleaning ######
win32{
hsdir.target = hsdir
hsdir.commands = mkdir build\hskiste & copy build\hskiste.exe build\hskiste \
			& copy build\hstarter.exe build\hskiste
channel.target	= channels
channel.commands	= copy data\channels build\hskiste  
channel.depends = hsdir

lang.target	= lang
lang.commands	= copy data\lang\* build\hskiste  
lang.depends = hsdir


addons.target	= addon
addons.commands	= mkdir build\hskiste\addons & copy addons\* build\hskiste\addons

wdepl.target	= windeploy
wdepl.commands	= copy C:\Qt\2010.05\qt\bin\QtCore4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtGui4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtDeclarative4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtNetwork4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtScript4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtSql4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\QtXmlPatterns4.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\mingwm10.dll build\hskiste \
			& copy C:\Qt\2010.05\qt\bin\libgcc_s_dw2-1.dll build\hskiste
wdepl.depends	= release channel lang addons
;wclean.commands	= rd /S /Q build\hskiste
;wclean.target	= winclean
;compiler_clean.depends	= wclean
QMAKE_EXTRA_TARGETS += channel wdepl hsdir lang addons
}
### end win32-deployment and cleaning ######



### begin installation (ubuntu,debian and maemo) ######
!maemo5 {
INSTALLS    += target
target.path  = /usr/bin/

INSTALLS	+= hstrt
hstrt.path  = /usr/bin/
hstrt.files  = build/hstarter

INSTALLS    += menudeb
menudeb.path  = /usr/share/menu/
menudeb.files  = data/hskiste

INSTALLS    += menu
menu.path  = /usr/share/applications/
menu.files  = data/hskiste.desktop
}


maemo5 {
INSTALLS    += target
target.path  = /opt/maemo/usr/bin/

INSTALLS	+= hstrt
hstrt.path  = /opt/maemo/usr/bin/
hstrt.files  = build/hstarter

}




maemo5 {
INSTALLS    += menu
menu.path  = /usr/share/applications/hildon
menu.files  = data/hskiste.desktop


; INSTALLS    += service
; service.path  = /usr/share/dbus-1/services
; service.files  = data/hskiste.service

INSTALLS    += icon64
icon64.path  = /opt/maemo/usr/share/icons/hicolor/64x64/apps
icon64.files  = data/64x64/hskiste.png

INSTALLS    += appshare
appshare.path  = /opt/maemo/usr/share/hskiste
appshare.files  = data/LICENSE \
		data/channels
		
INSTALLS    += lang
lang.path  = /opt/maemo/usr/share/hskiste/lang
lang.files  = data/lang/hslang_en.qm
		
INSTALLS    += addon
addon.path  = /opt/maemo/usr/share/hskiste/addons
addon.files  = addons/hskriminet.qml
}


!maemo5 {
INSTALLS    += icon64
icon64.path  = /usr/share/icons/hicolor/64x64/apps
icon64.files  = data/64x64/hskiste.png
	
	
INSTALLS    += appicons
appicons.path  = /usr/share/hskiste/icons
appicons.files  = data/hskiste.png \
		data/done.png \
		data/now.png \
		data/todo.png \
		data/notsaved.png

INSTALLS    += appshare
appshare.path  = /usr/share/hskiste
appshare.files  = data/LICENSE \
		data/channels
		
INSTALLS    += lang
lang.path  = /usr/share/hskiste/lang
lang.files  = data/lang/hslang_en.qm

INSTALLS    += addon
addon.path  = /usr/share/hskiste/addons
addon.files  = addons/hskriminet.qml
}
		

### end installation (ubuntu,debian and mamemo) ######


### begin targets for debian source and binary package creation #######
debian-src.commands = dpkg-buildpackage -S -r -us -uc -d
debian-bin.commands = dpkg-buildpackage -b -r -uc -d
debian-all.depends = debian-src debian-bin
QMAKE_EXTRA_TARGETS += debian-all debian-src debian-bin compiler_clean
### end targets for debian source and binary package creation ########

#
# Clean all but Makefile
#
compiler_clean.commands = -$(DEL_FILE) $(TARGET)

compiler_clean_extra.target = clean_extra
!win32:compiler_clean_extra.commands += make -f Makefile.hstarter clean
win32:compiler_clean_extra.commands += mingw32-make -f Makefile.hstarter clean
compiler_clean.depends	+= compiler_clean_extra
QMAKE_EXTRA_TARGETS += compiler_clean_extra


