#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    ui->labelUnsupportedKernel->hide();
    ui->vbusOffButton->hide();
    ui->unmountButton->hide();
    ui->helpButton->setIcon(QPixmap(":/general_help.png"));
    // Connect buttons to functions.
    connectButtons();
    MainWindow::kernelcheck();
    QMainWindow::setCentralWidget(ui->verticalLayoutWidget);
    if(!QFile::exists("/proc/driver/musb_hdrc")) {
        QMessageBox::critical(this, tr("Fatal Error"),
                              tr("h-e-n is running on a device that doesn't have the musb OTG driver!"));
        QApplication::exit(1);
        QMainWindow::close();
    }
}

MainWindow::~MainWindow()
{
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(0, tr("Starting BME."));
        MainWindow::unmount();
        system("boostoff");
        system("echo peripheral > /sys/devices/platform/musb_hdrc/mode");
        // Re-enable battery icon and reload the status menu.
        // Commented out for now, obviously not The Right Way(TM) :P
        //system("mv /opt/h-e-n/status-area-applet-battery.desktop /usr/share/applications/hildon-status-menu/ && killall hildon-status-menu");
        system("start bme &");
#endif
}

// About dialog.
void MainWindow::about()
{
    AboutWindow *myAboutWindow = new AboutWindow(this);
    myAboutWindow->show();
}

void MainWindow::connectButtons()
{
    // Menu buttons
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(about()));
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    connect(ui->actionKernel_messages, SIGNAL(triggered()), this, SLOT(kernelmessages())); // kernel messages menu item
    connect(ui->actionSettings1, SIGNAL(triggered()), this, SLOT(settingsDialog()));
    // Buttons in app.
    connect(ui->FShostmode, SIGNAL(clicked()), this, SLOT(hostmodeFS()));
    connect(ui->HShostmode, SIGNAL(clicked()), this, SLOT(hostmodeHS()));
    connect(ui->LShostmode, SIGNAL(clicked()), this, SLOT(hostmodeLS()));
    connect(ui->enumerateButton, SIGNAL(clicked()), this, SLOT(enumerate()));
    connect(ui->mountButton, SIGNAL(clicked()), this, SLOT(mount()));
    connect(ui->unmountButton, SIGNAL(clicked()), this, SLOT(unmount()));
    connect(ui->vbusOnButton, SIGNAL(clicked()), this, SLOT(vbusOn()));
    connect(ui->vbusOffButton, SIGNAL(clicked()), this, SLOT(vbusOff()));
    connect(ui->helpButton, SIGNAL(clicked()), this, SLOT(helpWindow()));
    connect(ui->overrideButton, SIGNAL(clicked()), this, SLOT(overrideKernelVersion()));
#ifdef Q_WS_MAEMO_5
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
#endif
}

void MainWindow::vbusOn()
{
    ui->vbusOnButton->hide();
    ui->vbusOffButton->show();
    ui->enumerateButton->setEnabled(true);
    ui->HShostmode->setEnabled(false);
    ui->FShostmode->setEnabled(false);
    ui->LShostmode->setEnabled(false);
#ifdef Q_WS_MAEMO_5
    system("booston &");
#endif
    ui->statusBar->showMessage(ui->statusBar->currentMessage() + tr(" - VBUS on"));
}

void MainWindow::vbusOff()
{
    ui->vbusOffButton->hide();
    ui->vbusOnButton->show();
#ifdef Q_WS_MAEMO_5
    MainWindow::unmount();
    system("boostoff");
#endif
    ui->HShostmode->setEnabled(true);
    ui->FShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->enumerateButton->setEnabled(false);
    ui->mountButton->setEnabled(false);
    ui->unmountButton->hide();
    ui->vbusOnButton->setEnabled(false);
    ui->statusBar->showMessage(tr("VBUS disabled"));
}

void MainWindow::mount()
{
#ifdef Q_WS_MAEMO_5
    if(QSettings().value("mount/openfilemanager").toString() == "true")
    {
        if(QSettings().value("mount/filemanager").toString() == "filebox")
            system("/opt/h-e-n/mount.sh --mount --openfilemanager --filebox");
        if(QSettings().value("mount/filemanager").toString() == "osso-filemanager")
            system("/opt/h-e-n/mount.sh --mount --openfilemanager --osso-filemanager");
    } else {
        system("/opt/h-e-n/mount.sh --mount");
    }
#endif
    ui->unmountButton->show();
}

void MainWindow::unmount()
{
#ifdef Q_WS_MAEMO_5
    system("/opt/h-e-n/mount.sh --unmount");
#endif
}

void MainWindow::kernelcheck()
{
    system("cat /proc/driver/musb_hdrc | sed 's/.*version_hostmode=\\(.*\\)/\\1/; t done; D; : done; q' > /var/tmp/.hostmodeversion");
    QFile file("/var/tmp/.hostmodeversion");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&file);
    QString APIversion = in.readLine();
                if (APIversion == API) {
                    qDebug() << "Kernel check passed";
                    ui->labelUnsupportedKernel->hide();
                    ui->quitButton->hide();
                    ui->overrideButton->hide();
                #ifdef Q_WS_MAEMO_5
                    QMaemo5InformationBox::information(this, tr("Stopping BME."));
                    qDebug() << "Stopping bme:";
                    system("stop bme &");
                    // Disable battery icon, what use is it if it's not updated?
                    //system("mv /usr/share/applications/hildon-status-menu/status-area-applet-battery.desktop /opt/h-e-n/");
                    // Make status bar say Ready.
                    statusBar()->showMessage(tr("Ready - Hostmode API version: ") + APIversion);
                #endif
                } else {
                    QFile osrelease("/proc/sys/kernel/osrelease");
                    osrelease.open(QIODevice::ReadOnly | QIODevice::Text);
                    QTextStream in(&osrelease);
                    QString osreleaseversion = in.readLine();
                    qDebug() << "Unsupported kernel detected" << osreleaseversion;
                    ui->labelUnsupportedKernel->show();
                    ui->vbusOnButton->hide();
                    ui->FShostmode->hide();
                    ui->HShostmode->hide();
                    ui->LShostmode->hide();
                    ui->mountButton->hide();
                    ui->enumerateButton->hide();
                    ui->step1Label->hide();
                    ui->step2Label->hide();
                    ui->step3Label->hide();
                    ui->step4Label->hide();
                    if(!APIversion.isEmpty())
                        statusBar()->showMessage(tr("ERROR! Current kernel version: ") + osreleaseversion + tr(" - API: ") + APIversion);
                    else
                        statusBar()->showMessage(tr("ERROR! Current kernel version: ") + osreleaseversion);
                    ui->labelUnsupportedKernel->show();
                    osrelease.close();
                }
    if(QFile::exists("/var/tmp/.hostmodeversion"))
        QFile::remove("/var/tmp/.hostmodeversion");
}

void MainWindow::overrideKernelVersion()
{
    ui->quitButton->hide();
    ui->overrideButton->hide();
    ui->labelUnsupportedKernel->hide();
    ui->vbusOnButton->show();
    ui->FShostmode->show();
    ui->HShostmode->show();
    ui->LShostmode->show();
    ui->mountButton->show();
    ui->enumerateButton->show();
    ui->step1Label->show();
    ui->step2Label->show();
    ui->step3Label->show();
    ui->step4Label->show();
#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this, tr("Stopping BME."));
    qDebug() << "Stopping bme:";
    system("stop bme &");
#endif
    ui->statusBar->showMessage(tr("Ready - WARNING: Hostmode API version mismatch, override enabled!"));
}

void MainWindow::hostmodeFS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hostf > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->FShostmode->setEnabled(false);
    ui->HShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("Full speed hostmode enabled"));
}

void MainWindow::hostmodeLS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hostl > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->LShostmode->setEnabled(false);
    ui->HShostmode->setEnabled(true);
    ui->FShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("Low speed hostmode enabled"));
}

void MainWindow::hostmodeHS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hosth > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->HShostmode->setEnabled(false);
    ui->FShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("High speed hostmode enabled"));
}

void MainWindow::enumerate()
{
    system("echo F > /proc/driver/musb_hdrc");
    ui->mountButton->setEnabled(true);
}

void MainWindow::kernelmessages()
{
    setWindowFlags(windowFlags() | Qt::Window);
    KernelMessagesWindow *myKernelMessagesWindow = new KernelMessagesWindow(this);
    myKernelMessagesWindow->showLogs();
    myKernelMessagesWindow->show();
}

void MainWindow::helpWindow()
{
    setWindowFlags(windowFlags() | Qt::Window);
    HelpWindow *myHelpWindow = new HelpWindow(this);
    myHelpWindow->show();
}

void MainWindow::settingsDialog()
{
    SettingsDialog *mySettingsDialog = new SettingsDialog(this);
    mySettingsDialog->show();
}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()) {
        ui->HShostmode->setText("High Speed hostmode");
        ui->LShostmode->setText("Low Speed hostmode");
        ui->FShostmode->setText("Full Speed hostmode");
    } else {
        ui->HShostmode->setText("High Speed");
        ui->LShostmode->setText("Low Speed");
        ui->FShostmode->setText("Full Speed");
    }
}
