#include "settingsdialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent)
{
    QScrollArea *scrollarea = new QScrollArea(this);

    scrollarea->setWidgetResizable(true);
    scrollarea->setWidget(new QWidget(this));

    m_Layout = new QVBoxLayout(scrollarea->widget());

    new QVBoxLayout(this);
    this->layout()->addWidget(scrollarea);

    this->setWindowTitle(tr("Options"));

    QCheckBox *checkbox = new QCheckBox(this);
    checkbox->setText(tr("Open file manager after mount"));
    if(QSettings().value("mount/openfilemanager").toString() == "true")
        checkbox->setChecked(true);
    else
        checkbox->setChecked(false);
    connect(checkbox, SIGNAL(toggled(bool)), this, SLOT(onToggleChanged(bool)));
    m_Layout->addWidget(checkbox);

    QLabel *filemanagerLabel = new QLabel(this);
    filemanagerLabel->setText(tr("Default file manager:"));
    m_Layout->addWidget(filemanagerLabel);

    QComboBox *filemanagerList = new QComboBox(this);
    filemanagerList->setEditable(false);
    filemanagerList->addItem(tr("File Manager"));
    if(QFile::exists("/usr/bin/filebox"))
        filemanagerList->addItem(tr("Filebox"));
    else
        filemanagerList->setEnabled(false);
    connect(filemanagerList, SIGNAL(activated(int)), this, SLOT(onFilemanagerSelected(int)));
    if(QSettings().value("mount/filemanager", "filebox").toString() == "filebox")
        filemanagerList->setCurrentIndex(1);
    m_Layout->addWidget(filemanagerList);
}

void SettingsDialog::onToggleChanged(bool value)
{
    if(value)
        QSettings().setValue("mount/openfilemanager", "true");
    else
        QSettings().setValue("mount/openfilemanager", "false");
}

void SettingsDialog::onFilemanagerSelected(int filemanagerValue)
{
    switch(filemanagerValue) {
    case 0:
        QSettings().setValue("mount/filemanager", "osso-filemanager");
        break;
    case 1:
        QSettings().setValue("mount/filemanager", "filebox");
        break;
    }
}
