#!/bin/sh

mountpartitions() {
for partitions in "`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*"`"
	do mkdir -p /media/$partitions
	/bin/mount /dev/$partitions /media/$partitions
done
}

unmount() {
for partitions in "`awk '$4~"[0-9]$"{print $4}' /proc/partitions | grep -v "mmcblk*"`"
	do umount /media/$partitions
done
}
	

if [ "$1" = "--mount" ]
	then
		mountpartitions
fi

if [ "$1" = "--unmount" ]
	then
		unmount
fi
	
