#include "mainwindow.h"
#include "ui_mainwindow.h"

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
#ifdef Q_WS_MAEMO_5
    setAttribute(Qt::WA_Maemo5StackedWindow);
    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
#endif
    ui->labelUnsupportedKernel->hide();
    ui->vbusOffButton->hide();
    ui->unmountButton->hide();
    ui->vbusOnButton->setEnabled(false);
    ui->enumerateButton->setEnabled(false);
    ui->mountButton->setEnabled(false);
    ui->helpButton->setIcon(QPixmap(":/general_help.png"));
    // Connect buttons to functions.
    connectButtons();
    // Make status bar say Ready.
    statusBar()->showMessage(tr("Ready"));
    MainWindow::kernelcheck();
    QMainWindow::setCentralWidget(ui->verticalLayoutWidget);
}

MainWindow::~MainWindow()
{
#ifdef Q_WS_MAEMO_5
        QMaemo5InformationBox::information(0, tr("Starting BME."));
        system("boostoff");
        system("echo peripheral > /sys/devices/platform/musb_hdrc/mode");
        system("start bme &");
#endif
    delete ui;
    system("rm -f /var/tmp/.kernelversion 2> /dev/null");
}

// About dialog.
void MainWindow::about()
{
    AboutWindow *myAboutWindow = new AboutWindow(this);
    myAboutWindow->show();
}

void MainWindow::connectButtons()
{
    // Menu buttons
    connect(ui->actionAbout, SIGNAL(triggered()), this, SLOT(about()));
    connect(ui->actionAbout_Qt, SIGNAL(triggered()), qApp, SLOT(aboutQt()));
    connect(ui->actionKernel_messages, SIGNAL(triggered()), this, SLOT(kernelmessages())); // kernel messages menu item
    connect(ui->actionHelp, SIGNAL(triggered()), this, SLOT(helpWindow()));
    // Buttons in app.
    connect(ui->FShostmode, SIGNAL(clicked()), this, SLOT(hostmodeFS()));
    connect(ui->HShostmode, SIGNAL(clicked()), this, SLOT(hostmodeHS()));
    connect(ui->LShostmode, SIGNAL(clicked()), this, SLOT(hostmodeLS()));
    connect(ui->enumerateButton, SIGNAL(clicked()), this, SLOT(enumerate()));
    connect(ui->mountButton, SIGNAL(clicked()), this, SLOT(mount()));
    connect(ui->unmountButton, SIGNAL(clicked()), this, SLOT(unmount()));
    connect(ui->vbusOnButton, SIGNAL(clicked()), this, SLOT(vbusOn()));
    connect(ui->vbusOffButton, SIGNAL(clicked()), this, SLOT(vbusOff()));
    connect(ui->helpButton, SIGNAL(clicked()), this, SLOT(helpWindow()));
#ifdef Q_WS_MAEMO_5
    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(orientationChanged()));
#endif
}

void MainWindow::vbusOn()
{
    ui->vbusOnButton->hide();
    ui->vbusOffButton->show();
    ui->enumerateButton->setEnabled(true);
    ui->HShostmode->setEnabled(false);
    ui->FShostmode->setEnabled(false);
    ui->LShostmode->setEnabled(false);
#ifdef Q_WS_MAEMO_5
    system("booston &");
#endif
    ui->statusBar->showMessage(ui->statusBar->currentMessage() + tr(" - VBUS on"));
}

void MainWindow::vbusOff()
{
    ui->vbusOffButton->hide();
    ui->vbusOnButton->show();
#ifdef Q_WS_MAEMO_5
    system("boostoff");
#endif
    ui->HShostmode->setEnabled(true);
    ui->FShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->enumerateButton->setEnabled(false);
    ui->mountButton->setEnabled(false);
    ui->unmountButton->hide();
    ui->vbusOnButton->setEnabled(false);
    ui->statusBar->showMessage(tr("VBUS disabled"));
}

void MainWindow::mount()
{
    system("/opt/h-e-n/mount.sh --mount");
    ui->unmountButton->show();
}

void MainWindow::unmount()
{
    system("/opt/h-e-n/mount.sh --unmount");
}

void MainWindow::kernelcheck()
{
    system("echo 2.6.28-hostmode2 > /var/tmp/.kernelversion");
    QFile file("/var/tmp/.kernelversion");
    file.open(QIODevice::ReadOnly | QIODevice::Text);
    QTextStream in(&file);
    QString kernelversion = in.readLine();
                if (kernelversion == "2.6.28-hostmode2") {
                    qDebug() << "Kernel check passed\n";
                    ui->labelUnsupportedKernel->hide();
                #ifdef Q_WS_MAEMO_5
                    QMaemo5InformationBox::information(this, tr("Stopping BME."));
                    system("stop bme &");
                #endif
                } else {
                    qDebug() << "Unsupported kernel detected:" << kernelversion;
                    ui->labelUnsupportedKernel->show();
                    ui->vbusOnButton->hide();
                    ui->FShostmode->hide();
                    ui->HShostmode->hide();
                    ui->LShostmode->hide();
                    ui->mountButton->hide();
                    ui->enumerateButton->hide();
                    ui->step1Label->hide();
                    ui->step2Label->hide();
                    ui->step3Label->hide();
                    ui->step4Label->hide();
                    statusBar()->showMessage(tr("ERROR: Unsupported kernel detected: ") + kernelversion);
                    ui->labelUnsupportedKernel->show();
                #ifdef Q_WS_MAEMO_5
                    QMaemo5InformationBox::information(0, tr("Unsupported kerenl detected"));
                #endif
                }
}

void MainWindow::hostmodeFS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hostf > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->FShostmode->setEnabled(false);
    ui->HShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("Full speed hostmode enabled"));
}

void MainWindow::hostmodeLS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hostl > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->LShostmode->setEnabled(false);
    ui->HShostmode->setEnabled(true);
    ui->FShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("Low speed hostmode enabled"));
}

void MainWindow::hostmodeHS()
{
#ifdef Q_WS_MAEMO_5
    system("echo hosth > /sys/devices/platform/musb_hdrc/mode");
#endif
    ui->HShostmode->setEnabled(false);
    ui->FShostmode->setEnabled(true);
    ui->LShostmode->setEnabled(true);
    ui->vbusOnButton->setEnabled(true);
    ui->statusBar->showMessage(tr("High speed hostmode enabled"));
}

void MainWindow::enumerate()
{
    system("echo F > /proc/driver/musb_hdrc");
    ui->mountButton->setEnabled(true);
}


void MainWindow::kernelmessages()
{
    setWindowFlags(windowFlags() | Qt::Window);
    KernelMessagesWindow *myKernelMessagesWindow = new KernelMessagesWindow(this);
    myKernelMessagesWindow->showLogs();
    myKernelMessagesWindow->show();
}

void MainWindow::helpWindow()
{
    setWindowFlags(windowFlags() | Qt::Window);
    HelpWindow *myHelpWindow = new HelpWindow(this);
    myHelpWindow->show();
}

void MainWindow::orientationChanged()
{
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    if (screenGeometry.width() > screenGeometry.height()) {
        ui->HShostmode->setText("High Speed hostmode");
        ui->LShostmode->setText("Low Speed hostmode");
        ui->FShostmode->setText("Full Speed hostmode");
    } else {
        ui->HShostmode->setText("High Speed");
        ui->LShostmode->setText("Low Speed");
        ui->FShostmode->setText("Full Speed");
    }
}
