#ifndef MAINWINDOW_H
#define MAINWINDOW_H
#include <kernelmessageswindow.h>
#include <helpwindow.h>
#include <QMainWindow>
#include <aboutwindow.h>
#include <QDebug>
#include <QIODevice>
#include <QFile>
#include <QtGui>
#include <stdlib.h>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#endif

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    QString *kernelversion;

private:
    Ui::MainWindow *ui;
    void connectButtons();
    void kernelcheck();

private slots:
    void about();
    void hostmodeFS();
    void hostmodeLS();
    void hostmodeHS();
    void mountdevsda1();
    void vbusOn();
    void vbusOff();
    void kernelmessages();
    void orientationChanged();
    void enumerate();
    void helpWindow();
};

#endif // MAINWINDOW_H
