#ifndef WIDGET_H
#define WIDGET_H

#include <QtCore>
#include <QtGui>
#include "qemaemo5dynamichomescreenwidget.h"

#include <QWidget>
#include <QPixmap>
#include <QGridLayout>
#include <QToolButton>


class QPaintEvent;
class QSvgRenderer;
class QResizeEvent;

class Widget : public QeMaemo5DynamicHomescreenWidget
{
    Q_OBJECT
public:
    static Widget *createAndShowNew();

    explicit Widget(QWidget *parent = 0);
    ~Widget();

public slots:
    void GetProg (QString file);
    void showSettingsDialog();
    void loadProgs();
    void orientationChanged(const QString& orientation);

private:
    QGridLayout *layout;

protected:
    void mouseReleaseEvent (QMouseEvent *ev);
    void paintEvent(QPaintEvent *event);
    bool restoreWidgetState();

};

#endif
