/****************************************************************************
**
** Copyright (C) 2007-2007 Trolltech ASA. All rights reserved.
**
** This file is part of the Graphics Dojo project on Trolltech Labs.
**
** This file may be used under the terms of the GNU General Public
** License version 2.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of
** this file.  Please review the following information to ensure GNU
** General Public Licensing requirements will be met:
** http://www.trolltech.com/products/qt/opensource.html
**
** If you are unsure which license is appropriate for your use, please
** review the following information:
** http://www.trolltech.com/products/qt/licensing.html or contact the
** sales department at sales@trolltech.com.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/
#include "widget.h"
#include "qtextcodec.h"
#include "appeventlistener.h"
#include <QApplication>

//#include "qmaemo5homescreenadaptor.h"
#include "qemaemo5dynamicwidgethelper.h"
#include "qtsingleapplication.h"

int main(int argc, char **argv)
{
    QApplication::setGraphicsSystem("native");
    QApplication::setApplicationName("Homescreen Dockbar");
    QApplication::setOrganizationName("cepiperez");

    QTextCodec *linuxCodec = QTextCodec::codecForName("UTF-8");
    QTextCodec::setCodecForTr(linuxCodec);
    QTextCodec::setCodecForCStrings(linuxCodec);
    QTextCodec::setCodecForLocale(linuxCodec);

    QtSingleApplication app(argc, argv);
    if (app.isRunning())
    {
        qDebug() << "Another instance of the app is running.";
        if (app.arguments().contains("in-background"))
        {
            qDebug() << "Closing that other instance.";
            app.sendMessage(APP_MESSAGE_CLOSE);
        }
        else
        {
            qDebug() << "Asking it to offer to create a new widget and closing this one.";
            app.sendMessage(APP_MESSAGE_ADDWIDGET);
            return 0;
        }
    }

    app.setQuitOnLastWindowClosed(false);
    AppEventListener listener;
    QObject::connect(&app, SIGNAL(messageReceived(const QString&)), &listener, SLOT(receiveMessage(const QString&)));

    if (app.arguments().contains("forget-widgets"))
    {
        qDebug() << "We were asked to forget all widgets!";
        QeMaemo5DynamicWidgetHelper::globalInstance()->forgetAllWidgets();
    }
    else
    {
        qDebug() << "Restoring all widgets";
        QeMaemo5DynamicWidgetHelper::globalInstance()->restoreWidgets<Widget>();
    }

    if (!app.arguments().contains("in-background") && QeMaemo5DynamicWidgetHelper::globalInstance()->widgets().count() == 0)
    {
        qDebug() << "Adding a new widget, as there are none yet.";
        Widget::createAndShowNew();
    }

    return app.exec();

}
