#include "widget.h"
#include "settings.h"

#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QBrush>
#include <QProcess>
#include <QToolButton>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>
#include <QtGui/QMessageBox>
#include <QSettings>
#include <QFile>
#include <QTextStream>
#include <QFileInfo>

#include <glib-2.0/glib-object.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include "locale.h"
//#include <gtk-2.0/gtk/gtk.h>
#include <gtk-2.0/gtk/gtkicontheme.h>



//rotation
#include <mce/dbus-names.h>
#include <mce/mode-names.h>
#include <QtDBus/QDBusConnection>
#include <QtDBus/QDBusMessage>


QProcess *Proc;
QStringList programs;
QString backimage;
QString backimg;
QLabel *desk1;
QLabel *desk2;
QLabel *desk3;
QLabel *desk4;
QLabel *desk5;
QLabel *desk6;
QLabel *desk7;
QLabel *desk8;
QLabel *desk9;
QLabel *desk10;
QString temp1,temp2;
QString windowmode, autorotate;
QString vertical;

Widget *Widget::createAndShowNew()
{
    Widget *widget = new Widget();
    widget->show();
    return widget;
}

Widget::Widget(QWidget *parent)
    : QeMaemo5DynamicHomescreenWidget(true, parent)
{
    layout = new QGridLayout(this);
    
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);

    Proc = new QProcess(this);

    QDBusConnection::systemBus().call(QDBusMessage::createMethodCall(MCE_SERVICE, MCE_REQUEST_PATH, MCE_REQUEST_IF, MCE_ACCELEROMETER_ENABLE_REQ));
    QDBusConnection::systemBus().connect(QString(), MCE_SIGNAL_PATH, MCE_SIGNAL_IF, MCE_DEVICE_ORIENTATION_SIG, this, SLOT(orientationChanged(QString)));

    loadProgs();
}

void Widget::orientationChanged(const QString &orientation)
{
    if (orientation == QLatin1String(MCE_ORIENTATION_PORTRAIT) || orientation == QLatin1String(MCE_ORIENTATION_PORTRAIT_INVERTED))
    {
        windowmode = "Portrait";
    }
    else
    {
        windowmode = "Landscape";
    }
    loadProgs();
}


void Widget::mouseReleaseEvent(QMouseEvent *event)
{
    qDebug() << "Mouse release event" << event->x() << event->y();

    programs = loadSetting("Programs").toStringList();
    QString proc;

    int i = event->x();
    if ( i > 20 && i < 75  && programs.count() > 0 )
        proc = programs.at(0);
    else if ( i > 95 && i < 150 && programs.count() > 1 )
        proc = programs.at(1);
    else if ( i > 170 && i < 225 && programs.count() > 2 )
        proc = programs.at(2);
    else if ( i > 245 && i < 300 && programs.count() > 3 )
        proc = programs.at(3);
    else if ( i > 320 && i < 375 && programs.count() > 4 )
        proc = programs.at(4);
    else if ( i > 395 && i < 450 && programs.count() > 5 )
        proc = programs.at(5);
    else if ( i > 470 && i < 525 && programs.count() > 6 )
        proc = programs.at(6);
    else if ( i > 545 && i < 600 && programs.count() > 7 )
        proc = programs.at(7);
    else if ( i > 620 && i < 675 && programs.count() > 8 )
        proc = programs.at(8);
    else if ( i > 695 && i < 750 && programs.count() > 9 )
        proc = programs.at(9);
    else
         return;

    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + proc;
    Proc->start(proceso, QProcess::ReadOnly);


}

void Widget::loadProgs()
{
    //QCoreApplication::processEvents();

    programs = loadSetting("Programs",QStringList()).toStringList();
    backimage = loadSetting("Background","YES").toString();
    autorotate = loadSetting("Autorotation","NO").toString();
    vertical = loadSetting("Vertical","NO").toString();

    if ( vertical == "NO" )
        QWidget::resize(programs.count()*75 + 12, 70);
    else
        QWidget::resize(70, programs.count()*75 + 12);

    if ( programs.count() == 0 )
        QWidget::resize(70, 70);

    update();

}

void Widget::GetProg(QString file)
{

    QString line, texto, dominio, icon, icono, tipo, mostrar;
    texto=""; dominio=""; icon="", tipo="", mostrar="";
    QFile data( "/usr/share/applications/hildon/" + file + ".desktop" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("Name=") == 0 ) if ( texto=="") texto = line;
             if ( line.indexOf("Icon=") == 0 ) icon = line;
             if ( line.indexOf("Type=") == 0 ) tipo = line;
             if ( line.indexOf("NoDisplay=") == 0 ) mostrar = line;
             if ( line.indexOf("X-Text-Domain=") == 0 ) dominio = line;
         }
     }
    data.close();
    texto.replace("Name=",""); texto = texto.trimmed();
    icon.replace("Icon=",""); icon = icon.trimmed();
    tipo.replace("Type=",""); tipo = tipo.trimmed();
    mostrar.replace("NoDisplay=",""); mostrar = mostrar.trimmed();
    dominio.replace("X-Text-Domain=",""); dominio = dominio.trimmed();

    QString tema = "";
    QFile data2( "/etc/hildon/theme/index.theme" );
    if (data2.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data2);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("IconTheme=") == 0 ) if ( tema=="") tema = line;
         }
     }
    data2.close();
    tema.replace("IconTheme=","");
    tema = tema.trimmed();


    if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/usr/share/pixmaps/" + icon + ".png";
    else if ( QFileInfo("/opt/maemo/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/opt/maemo/usr/share/pixmaps/" + icon + ".png";
    else icono = "/usr/share/icons/hicolor/64x64/hildon/tasklaunch_default_application.png";

    if ( dominio == "" ) dominio = "maemo-af-desktop";
    QByteArray ba1 = texto.toLatin1();
    const char *str1 = ba1.data();
    QByteArray ba2 = dominio.toLatin1();
    const char *str2 = ba2.data();

    texto = dgettext(str2,str1);

    temp1 = file;
    temp2 = icono;


}

Widget::~Widget()
{
    //delete ui;
}

void Widget::paintEvent(QPaintEvent *e)
{

    programs = loadSetting("Programs",QStringList()).toStringList();
    backimage = loadSetting("Background","YES").toString();
    autorotate = loadSetting("Autorotation","NO").toString();
    vertical = loadSetting("Vertical","NO").toString();

    QPainter p(this);
    QMatrix matrix;
    matrix.rotate(-90);

    if ( backimage == "YES" )
    {
        QImage img;
        backimg = loadSetting("Backimage").toString();
        if ( QFileInfo(backimg).exists() )
            img.load(backimg);
        else
        {
            if ( vertical == "NO" ) img.load("/home/user/homescreen-dockbar.png");
            else img.load("/home/user/homescreen-dockbar-portrait.png");
        }

        img = img.scaled(this->width(), this->height(), Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        QPixmap p1( QPixmap::fromImage(img) );
        p.drawPixmap(0, 0, p1);
    }

    int lft = 20;
    int top = 20;
    int space = 75;
    if ( (programs.count() > 0) && (programs.at(0) != "") )
    {
        GetProg(programs.at(0));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 1) && (programs.at(1) != "") )
    {
        GetProg(programs.at(1));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

   if ( (programs.count() > 2) && (programs.at(2) != "") )
    {
        GetProg(programs.at(2));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 3) && (programs.at(3) != "") )
    {
        GetProg(programs.at(3));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 4) && (programs.at(4) != "") )
    {
        GetProg(programs.at(4));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 5) && (programs.at(5) != "") )
    {
        GetProg(programs.at(5));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 6) && (programs.at(6) != "") )
    {
        GetProg(programs.at(6));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 7) && (programs.at(7) != "") )
    {
        GetProg(programs.at(7));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 8) && (programs.at(8) != "") )
    {
        GetProg(programs.at(8));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }

    if ( (programs.count() > 9) && (programs.at(9) != "") )
    {
        GetProg(programs.at(9));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);
        if ( windowmode == "Portrait" && autorotate == "YES") img = img.transformed(matrix);
        if ( vertical == "NO" ) { p.drawImage(lft,10,img); lft = lft + space; }
        else  { p.drawImage(10,top,img); top = top + space; }
    }



}

bool Widget::restoreWidgetState()
{
    loadProgs();

    return true;
}

void Widget::showSettingsDialog()
{
    QSettings settings( "cepiperez", "homescreen-dockbar" );
    settings.setValue( "Programs", loadSetting("Programs", QStringList()).toStringList() );
    settings.setValue( "Background", loadSetting("Background", "NO").toString() );
    settings.setValue( "Backimage", loadSetting("Backimage", "").toString() );
    settings.setValue( "Autorotation", loadSetting("Autorotation", "NO").toString() );
    settings.setValue( "Vertical", loadSetting("Vertical", "NO").toString() );

    Settings* dlg = new Settings(0);
    dlg->exec();
    dlg->close();

    settings.sync();
    saveSetting("Programs", settings.value("Programs",QStringList()).toStringList() );
    saveSetting("Background",settings.value("Background","NO").toString());
    saveSetting("Backimage",settings.value("Backimage","/home/user/homescreen-dockbar.png").toString());
    saveSetting("Autorotation",settings.value("Autorotation","NO").toString());
    saveSetting("Vertical",settings.value("Vertical","NO").toString());

    programs = settings.value("Programs",QStringList()).toStringList();
    QFile::remove("/home/user/.config/cepiperez/homescreen-dockbar.conf");

    loadProgs();

}

