#include "items.h"
#include "ui_items.h"
#include <QDir>
#include <QTextStream>
#include <QFile>
#include <QFileInfo>
#include <QListWidgetItem>
#include <QSettings>

#include <glib-2.0/glib-object.h>
//#include <libhildondesktop-1/libhildondesktop/libhildondesktop.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include "locale.h"
//#include <gtk-2.0/gtk/gtk.h>
#include <gtk-2.0/gtk/gtkicontheme.h>

int lugar;

Items::Items(QWidget *parent, int place) :
    QDialog(parent),
    ui(new Ui::Items)
{
    ui->setupUi(this);

    lugar = place;

    QDir dir ( "/usr/share/applications/hildon", "*" );
    dir.setFilter( QDir::Files | QDir::Hidden | QDir::NoDotAndDotDot );
    if ( !dir.isReadable() ) return;

    QListWidgetItem *item0 = new QListWidgetItem( ui->listWidget );
    item0->setIcon(QIcon("/usr/share/icons/hicolor/48x48/general_exit.png"));
    item0->setText("(remove)");
    item0->setToolTip("REMOVE");
    ui->listWidget->insertItem( 0, item0 );

    QString tema = "";
    QFile data2( "/etc/hildon/theme/index.theme" );
    if (data2.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data2);
         while ( !out.atEnd() )
         {
             QString line = out.readLine();
             if ( line.indexOf("IconTheme=") == 0 ) if ( tema=="") tema = line;
         }
     }
    data2.close();
    tema.replace("IconTheme=","");
    tema = tema.trimmed();

    QIcon ic1 = QPixmap("/usr/share/icons/" + tema + "/48x48/hildon/general_close.png");
    ui->qsearch->setIcon( ic1 );

    ui->search->setText("");
    ui->swidget->setVisible(false);

    QFileInfoList list = dir.entryInfoList();
    for (int i = 0; i < list.size(); ++i)
    {

        QString line, texto, dominio, icon, tipo, mostrar;
        texto=""; dominio=""; icon="", tipo="", mostrar="";
        QFile data( list.at(i).absoluteFilePath() );
        if (data.open(QFile::ReadOnly | QFile::Truncate))
        {
             QTextStream out(&data);
             while ( !out.atEnd() )
             {
                 line = out.readLine();
                 if ( line.indexOf("Name=") == 0 ) if ( texto=="") texto = line;
                 if ( line.indexOf("Icon=") == 0 ) icon = line;
                 if ( line.indexOf("Type=") == 0 ) tipo = line;
                 if ( line.indexOf("NoDisplay=") == 0 ) mostrar = line;
                 if ( line.indexOf("X-Text-Domain=") == 0 ) dominio = line;
             }
         }
        data.close();
        texto.replace("Name=","");
        icon.replace("Icon=","");
        tipo.replace("Type=","");
        mostrar.replace("NoDisplay=","");
        dominio.replace("X-Text-Domain=","");

        if ( texto!="" && tipo=="Application" && mostrar!="true" )
        {
            QListWidgetItem *item1 = new QListWidgetItem( ui->listWidget );

            QByteArray ba1 = texto.toLatin1();
            const char *str1 = ba1.data();
            QByteArray ba2 = dominio.toLatin1();
            const char *str2 = ba2.data();

            if ( dominio == "" ) dominio="maemo-af-desktop";

            texto = dgettext(str2,str1);

            item1->setData(Qt::DisplayRole, "  " + texto );

            item1->setStatusTip( list.at(i).absoluteFilePath() );

            item1->setFlags(Qt::ItemIsSelectable|Qt::ItemIsEnabled);

            QImage icono;

            if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png");

            else if ( QFileInfo("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png");
            else if ( QFileInfo("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png").exists() )
                icono.load("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png");

            else if ( QFileInfo("/usr/share/pixmaps/" + icon + ".png").exists() )
                icono.load("/usr/share/pixmaps/" + icon + ".png");
            else if ( QFileInfo("/opt/maemo/usr/share/pixmaps/" + icon + ".png").exists() )
                icono.load("/opt/maemo/usr/share/pixmaps/" + icon + ".png");
            else icono.load("/usr/share/icons/hicolor/64x64/hildon/tasklaunch_default_application.png");

            icono = icono.scaled(48, 48, Qt::KeepAspectRatio, Qt::FastTransformation);

            item1->setData(Qt::DecorationRole, QPixmap::fromImage(icono));

            QString tip = list.at(i).fileName();
            tip.replace(".desktop","");
            item1->setToolTip(tip);

            ui->listWidget->insertItem( i, item1 );

        }
        ui->listWidget->sortItems(Qt::AscendingOrder);

    }
}

Items::~Items()
{
    delete ui;
}

void Items::on_listWidget_itemClicked(QListWidgetItem* item)
{
    QString tip = item->toolTip();
    QSettings settings("cepiperez","homescreen-dockbar");
    QStringList progs = settings.value("Programs",QStringList()).toStringList();

    if ( tip == "REMOVE" )
    {
        progs.removeAt(lugar);
    }
    else
    {
        if ( progs.count() > lugar)
            progs.replace(lugar,tip);
        else
            progs.append(tip);
    }

    settings.setValue("Programs",progs);
    settings.sync();
    this->close();

}

void Items::keyReleaseEvent(QKeyEvent* k)
{
    if ( ui->search->hasFocus()==false )
    {
        ui->swidget->setVisible(true);
        ui->search->setFocus();
        if ( k->key() == 16777219 )
        {
            QString pepe = ui->search->text();
            if ( pepe.length() > 0 ) pepe.remove(pepe.length()-1,1);
            ui->search->setFocus(); ui->search->setText(pepe);
            return;
        }
        else
        {
            ui->search->setText( ui->search->text() + k->text() );
        }
    }

}

void Items::on_search_textChanged(QString filter)
{
    ui->search->setText( ui->search->text().toLower() );
    for ( int i=0; i < ui->listWidget->count(); ++i)
    {
        if ( ui->listWidget->item(i)->text().toLower().indexOf( filter.toLower() )  == -1 )
        {
            ui->listWidget->item(i)->setHidden(true);
        }
        else
        {
            ui->listWidget->item(i)->setHidden(false);
        }
    }
}

void Items::on_qsearch_clicked()
{
    ui->search->setText("");
    ui->swidget->setVisible(false);
}
