#include "widget.h"
#include "settings.h"

#include <QPainter>
#include <QPaintEvent>
#include <QPen>
#include <QBrush>
#include <QProcess>
#include <QToolButton>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <QtGui/QX11Info>
#include <QtCore/QByteArray>
#include <QtCore/QCoreApplication>
#include <QtGui/QMessageBox>
#include <QSettings>
#include <QFile>
#include <QTextStream>
#include <QFileInfo>

#include <glib-2.0/glib-object.h>
//#include <libhildondesktop-1/libhildondesktop/libhildondesktop.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include "locale.h"
//#include <gtk-2.0/gtk/gtk.h>
#include <gtk-2.0/gtk/gtkicontheme.h>



QProcess *Proc;
QStringList programs;
QToolButton *desk1;
QToolButton *desk2;
QToolButton *desk3;
QToolButton *desk4;
QToolButton *desk5;
QToolButton *desk6;
QToolButton *desk7;
QToolButton *desk8;
QToolButton *desk9;
QToolButton *desk10;
QString temp1,temp2;


Widget::Widget()
    : QWidget(0, Qt::FramelessWindowHint)
{
    layout = new QGridLayout(this);
    
    desk1 = new QToolButton(this); desk2 = new QToolButton(this); desk3 = new QToolButton(this);
    desk4 = new QToolButton(this); desk5 = new QToolButton(this); desk6 = new QToolButton(this);
    desk7 = new QToolButton(this); desk8 = new QToolButton(this); desk9 = new QToolButton(this);
    desk10 = new QToolButton(this);

    desk1->setIconSize(QSize(48,48)); desk2->setIconSize(QSize(48,48));
    desk3->setIconSize(QSize(48,48)); desk4->setIconSize(QSize(48,48));
    desk5->setIconSize(QSize(48,48)); desk6->setIconSize(QSize(48,48));
    desk7->setIconSize(QSize(48,48)); desk8->setIconSize(QSize(48,48));
    desk9->setIconSize(QSize(48,48)); desk10->setIconSize(QSize(48,48));

    desk1->resize(48,48); desk2->resize(48,48); desk3->resize(48,48);
    desk4->resize(48,48); desk5->resize(48,48); desk6->resize(48,48);
    desk7->resize(48,48); desk8->resize(48,48); desk9->resize(48,48);
    desk10->resize(48,48);

    layout->setSpacing(0);
    layout->addWidget(desk1,0,0);
    layout->addWidget(desk2,0,1); desk2->setVisible(false);
    layout->addWidget(desk3,0,2); desk3->setVisible(false);
    layout->addWidget(desk4,0,3); desk4->setVisible(false);
    layout->addWidget(desk5,0,4); desk5->setVisible(false);
    layout->addWidget(desk6,0,5); desk6->setVisible(false);
    layout->addWidget(desk7,0,6); desk7->setVisible(false);
    layout->addWidget(desk8,0,7); desk8->setVisible(false);
    layout->addWidget(desk9,0,8); desk9->setVisible(false);
    layout->addWidget(desk10,0,9); desk10->setVisible(false);

    connect(desk1, SIGNAL( clicked() ), this, SLOT( desktop1() ) );
    connect(desk2, SIGNAL( clicked() ), this, SLOT( desktop2() ) );
    connect(desk3, SIGNAL( clicked() ), this, SLOT( desktop3() ) );
    connect(desk4, SIGNAL( clicked() ), this, SLOT( desktop4() ) );
    connect(desk5, SIGNAL( clicked() ), this, SLOT( desktop5() ) );
    connect(desk6, SIGNAL( clicked() ), this, SLOT( desktop6() ) );
    connect(desk7, SIGNAL( clicked() ), this, SLOT( desktop7() ) );
    connect(desk8, SIGNAL( clicked() ), this, SLOT( desktop8() ) );
    connect(desk9, SIGNAL( clicked() ), this, SLOT( desktop9() ) );
    connect(desk10, SIGNAL( clicked() ), this, SLOT( desktop10() ) );


    setContentsMargins(0, 0, 0, 0);
    layout->setContentsMargins(0, 0, 0, 0);
    setLayout(layout);
    setAttribute(Qt::WA_TranslucentBackground);
    setAttribute(Qt::WA_OpaquePaintEvent);

    Proc = new QProcess(this);

    loadProgs();

}

void Widget::loadProgs()
{
    QSettings settings("cepiperez","homescreen-dockbar");





    programs = settings.value("Programs",QStringList()).toStringList();

    if ( (programs.count() > 0) && (programs.at(0) != "") )
    {
        desk1->setVisible(true);
        GetProg(programs.at(0));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk1->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk1->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk1->setToolTip(temp1);
    }
    else desk1->setVisible(false);

    if ( (programs.count() > 1) && (programs.at(1) != "") )
    {
        desk2->setVisible(true);
        GetProg(programs.at(1));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk2->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk2->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk2->setToolTip(temp1);
    }
    else desk2->setVisible(false);

   if ( (programs.count() > 2) && (programs.at(2) != "") )
    {
        desk3->setVisible(true);
        GetProg(programs.at(2));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk3->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk3->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk3->setToolTip(temp1);
    }
    else desk3->setVisible(false);

    if ( (programs.count() > 3) && (programs.at(3) != "") )
    {
        desk4->setVisible(true);
        GetProg(programs.at(3));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk4->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk4->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk4->setToolTip(temp1);
    }
    else desk4->setVisible(false);

    if ( (programs.count() > 4) && (programs.at(4) != "") )
    {
        desk5->setVisible(true);
        GetProg(programs.at(4));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk5->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk5->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk5->setToolTip(temp1);
    }
    else desk5->setVisible(false);

    if ( (programs.count() > 5) && (programs.at(5) != "") )
    {
        desk6->setVisible(true);
        GetProg(programs.at(5));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk6->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk6->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk6->setToolTip(temp1);
    }
    else desk6->setVisible(false);

    if ( (programs.count() > 6) && (programs.at(6) != "") )
    {
        desk7->setVisible(true);
        GetProg(programs.at(6));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk7->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk7->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk7->setToolTip(temp1);
    }
    else desk7->setVisible(false);

    if ( (programs.count() > 7) && (programs.at(7) != "") )
    {
        desk8->setVisible(true);
        GetProg(programs.at(7));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk8->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk8->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk8->setToolTip(temp1);
    }
    else desk8->setVisible(false);

    if ( (programs.count() > 8) && (programs.at(8) != "") )
    {
        desk9->setVisible(true);
        GetProg(programs.at(8));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk9->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk9->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk9->setToolTip(temp1);
    }
    else desk9->setVisible(false);

    if ( (programs.count() > 9) && (programs.at(9) != "") )
    {
        desk10->setVisible(true);
        GetProg(programs.at(9));
        QImage img ( temp2 );
        img = img.scaled(48, 48, Qt::KeepAspectRatio, Qt::SmoothTransformation);
        desk10->setIcon( QIcon(QPixmap::fromImage(img)) );
        desk10->setSizePolicy(QSizePolicy::MinimumExpanding,QSizePolicy::MinimumExpanding);
        desk10->setToolTip(temp1);
    }
    else desk10->setVisible(false);



    layout->setContentsMargins(6, 0, 6, 0);

    QCoreApplication::processEvents();

    QWidget::resize(programs.count()*48 + 12, 70);
    //this->resize(views.count()*72 -1, 47);

    update();

}

void Widget::GetProg(QString file)
{

    QString line, texto, dominio, icon, icono, tipo, mostrar;
    texto=""; dominio=""; icon="", tipo="", mostrar="";
    QFile data( "/usr/share/applications/hildon/" + file + ".desktop" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("Name=") == 0 ) if ( texto=="") texto = line;
             if ( line.indexOf("Icon=") == 0 ) icon = line;
             if ( line.indexOf("Type=") == 0 ) tipo = line;
             if ( line.indexOf("NoDisplay=") == 0 ) mostrar = line;
             if ( line.indexOf("X-Text-Domain=") == 0 ) dominio = line;
         }
     }
    data.close();
    texto.replace("Name=",""); texto = texto.trimmed();
    icon.replace("Icon=",""); icon = icon.trimmed();
    tipo.replace("Type=",""); tipo = tipo.trimmed();
    mostrar.replace("NoDisplay=",""); mostrar = mostrar.trimmed();
    dominio.replace("X-Text-Domain=",""); dominio = dominio.trimmed();

    QString tema = "";
    QFile data2( "/etc/hildon/theme/index.theme" );
    if (data2.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data2);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("IconTheme=") == 0 ) if ( tema=="") tema = line;
         }
     }
    data2.close();
    tema.replace("IconTheme=","");
    tema = tema.trimmed();


    if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/usr/share/pixmaps/" + icon + ".png";
    else if ( QFileInfo("/opt/maemo/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/opt/maemo/usr/share/pixmaps/" + icon + ".png";
    else icono = "/usr/share/icons/hicolor/64x64/hildon/tasklaunch_default_application.png";

    if ( dominio == "" ) dominio = "maemo-af-desktop";
    QByteArray ba1 = texto.toLatin1();
    const char *str1 = ba1.data();
    QByteArray ba2 = dominio.toLatin1();
    const char *str2 = ba2.data();

    texto = dgettext(str2,str1);

    temp1 = file;
    temp2 = icono;


}

void Widget::desktop1()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk1->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop2()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk2->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop3()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk3->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop4()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk4->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop5()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk5->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop6()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk6->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop7()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk7->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop8()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk8->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop9()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk9->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::desktop10()
{
    QString proceso = "/usr/bin/dbus-send --dest=com.nokia.HildonDesktop.AppMgr /com/nokia/HildonDesktop/AppMgr com.nokia.HildonDesktop.AppMgr.LaunchApplication string:" + desk10->toolTip();
    Proc->start(proceso, QProcess::ReadOnly);
}

void Widget::paintEvent(QPaintEvent *e)
{
    QSettings settings("cepiperez","homescreen-dockbar");
    if ( settings.value("Background","NO") == "NO" )
        return;

    QPainter p(this);

    QImage img ( "/home/user/homescreen-dockbar.png" );
    img = img.scaled(this->width(), 70, Qt::IgnoreAspectRatio, Qt::SmoothTransformation);

    QPixmap p1( QPixmap::fromImage(img) );

    p.drawPixmap(0, 0, p1);

}

void Widget::showSettingsDialog()
{
    Settings dlg;
    dlg.exec();
    loadProgs();
    update(); // Repaint required if bgAlpha value was changed
}

