#include "settings.h"
#include "ui_settings.h"
#include "items.h"
#include <QSettings>
#include <QFile>
#include <QTextStream>
#include <QFileInfo>

#include <glib-2.0/glib-object.h>
//#include <libhildondesktop-1/libhildondesktop/libhildondesktop.h>
#include <libintl.h>
#include <locale.h>
#include <string.h>
#include "locale.h"
//#include <gtk-2.0/gtk/gtk.h>
#include <gtk-2.0/gtk/gtkicontheme.h>

QString tem1, tem2;
QStringList programas;

Settings::Settings(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Settings)
{
    ui->setupUi(this);

    LoadAll();


}

void Settings::LoadAll()
{
    QSettings settings("cepiperez","homescreen-dockbar");
    programas = settings.value("Programs",QStringList()).toStringList();

    if ( settings.value("Background","NO") == "NO" )
        ui->checkBox->setChecked(false);
    else
        ui->checkBox->setChecked(true);

    if ( (programas.count() > 0) && (programas.at(0) != "") )
    {
        GetProgram(programas.at(0));
        ui->pushButton->setText(tem1);
        ui->pushButton->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton->setText("");
        ui->pushButton->setIcon(QIcon());
    }

    if ( (programas.count() > 1) && (programas.at(1) != "") )
    {
        GetProgram(programas.at(1));
        ui->pushButton_2->setText(tem1);
        ui->pushButton_2->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_2->setText("");
        ui->pushButton_2->setIcon(QIcon());
    }

    if ( (programas.count() > 2) && (programas.at(2) != "") )
    {
        GetProgram(programas.at(2));
        ui->pushButton_3->setText(tem1);
        ui->pushButton_3->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_3->setText("");
        ui->pushButton_3->setIcon(QIcon());
    }

    if ( (programas.count() > 3) && (programas.at(3) != "") )
    {
        GetProgram(programas.at(3));
        ui->pushButton_4->setText(tem1);
        ui->pushButton_4->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_4->setText("");
        ui->pushButton_4->setIcon(QIcon());
    }

    if ( (programas.count() > 4) && (programas.at(4) != "") )
    {
        GetProgram(programas.at(4));
        ui->pushButton_5->setText(tem1);
        ui->pushButton_5->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_5->setText("");
        ui->pushButton_5->setIcon(QIcon());
    }

    if ( (programas.count() > 5) && (programas.at(5) != "") )
    {
        GetProgram(programas.at(5));
        ui->pushButton_6->setText(tem1);
        ui->pushButton_6->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_6->setText("");
        ui->pushButton_6->setIcon(QIcon());
    }

    if ( (programas.count() > 6) && (programas.at(6) != "") )
    {
        GetProgram(programas.at(6));
        ui->pushButton_7->setText(tem1);
        ui->pushButton_7->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_7->setText("");
        ui->pushButton_7->setIcon(QIcon());
    }

    if ( (programas.count() > 7) && (programas.at(7) != "") )
    {
        GetProgram(programas.at(7));
        ui->pushButton_8->setText(tem1);
        ui->pushButton_8->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_8->setText("");
        ui->pushButton_8->setIcon(QIcon());
    }

    if ( (programas.count() > 8) && (programas.at(8) != "") )
    {
        GetProgram(programas.at(8));
        ui->pushButton_9->setText(tem1);
        ui->pushButton_9->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_9->setText("");
        ui->pushButton_9->setIcon(QIcon());
    }

    if ( (programas.count() > 9) && (programas.at(9) != "") )
    {
        GetProgram(programas.at(9));
        ui->pushButton_10->setText(tem1);
        ui->pushButton_10->setIcon(QIcon(tem2));
    }
    else
    {
        ui->pushButton_10->setText("");
        ui->pushButton_10->setIcon(QIcon());
    }


}

Settings::~Settings()
{
    delete ui;
}

void Settings::GetProgram(QString file)
{

    QString line, texto, dominio, icon, icono, tipo, mostrar;
    texto=""; dominio=""; icon="", tipo="", mostrar="";
    QFile data( "/usr/share/applications/hildon/" + file + ".desktop" );
    if (data.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("Name=") == 0 ) if ( texto=="") texto = line;
             if ( line.indexOf("Icon=") == 0 ) icon = line;
             if ( line.indexOf("Type=") == 0 ) tipo = line;
             if ( line.indexOf("NoDisplay=") == 0 ) mostrar = line;
             if ( line.indexOf("X-Text-Domain=") == 0 ) dominio = line;
         }
     }
    data.close();
    texto.replace("Name=",""); texto = texto.trimmed();
    icon.replace("Icon=",""); icon = icon.trimmed();
    tipo.replace("Type=",""); tipo = tipo.trimmed();
    mostrar.replace("NoDisplay=",""); mostrar = mostrar.trimmed();
    dominio.replace("X-Text-Domain=",""); dominio = dominio.trimmed();

    QString tema = "";
    QFile data2( "/etc/hildon/theme/index.theme" );
    if (data2.open(QFile::ReadOnly | QFile::Truncate))
    {
         QTextStream out(&data2);
         while ( !out.atEnd() )
         {
             line = out.readLine();
             if ( line.indexOf("IconTheme=") == 0 ) if ( tema=="") tema = line;
         }
     }
    data2.close();
    tema.replace("IconTheme=","");
    tema = tema.trimmed();


    if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/" + tema + "/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/48x48/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/48x48/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/64x64/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/64x64/apps/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/hildon/" + icon + ".png";
    else if ( QFileInfo("/usr/share/icons/hicolor/scalable/apps/" + icon + ".png").exists() )
        icono = "/usr/share/icons/hicolor/scalable/apps/" + icon + ".png";

    else if ( QFileInfo("/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/usr/share/pixmaps/" + icon + ".png";
    else if ( QFileInfo("/opt/maemo/usr/share/pixmaps/" + icon + ".png").exists() )
        icono = "/opt/maemo/usr/share/pixmaps/" + icon + ".png";
    else icono = "/usr/share/icons/hicolor/64x64/hildon/tasklaunch_default_application.png";

    if ( dominio == "" ) dominio="maemo-af-desktop";
    QByteArray ba1 = texto.toLatin1();
    const char *str1 = ba1.data();
    QByteArray ba2 = dominio.toLatin1();
    const char *str2 = ba2.data();

    texto = dgettext(str2,str1);

    tem1 = texto;
    tem2 = icono;


}


void Settings::on_pushButton_clicked()
{
    Items* it = new Items(this,0);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_2_clicked()
{
    Items* it = new Items(this,1);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_3_clicked()
{
    Items* it = new Items(this,2);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_4_clicked()
{
    Items* it = new Items(this,3);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_5_clicked()
{
    Items* it = new Items(this,4);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_6_clicked()
{
    Items* it = new Items(this,5);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_7_clicked()
{
    Items* it = new Items(this,6);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_8_clicked()
{
    Items* it = new Items(this,7);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_9_clicked()
{
    Items* it = new Items(this,8);
    it->exec(); LoadAll();
}

void Settings::on_pushButton_10_clicked()
{
    Items* it = new Items(this,9);
    it->exec(); LoadAll();
}


void Settings::on_checkBox_stateChanged(int )
{
    QSettings settings("cepiperez","homescreen-dockbar");
    if ( ui->checkBox->isChecked() )
        settings.setValue("Background","YES");
    else
        settings.setValue("Background","NO");
    settings.sync();
}
