// Generated by gtkmmproc -- DO NOT MODIFY!


#include <hildonmm/pannable-area.h>
#include <hildonmm/private/pannable-area_p.h>

/*
 * Copyright (c) 2009  The maemomm Development Team
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <hildon/hildon.h>

namespace Hildon
{

void PannableArea::add(Gtk::Widget& widget)
{
  GtkWidget *const child = widget.gobj();

  // Wrap widgets without native scrolling ability into a Gtk::Viewport.
  // This check is courtesy of James Henstridge on gtk-devel-list@gnome.org.
  if (GTK_WIDGET_GET_CLASS(child)->set_scroll_adjustments_signal == 0)
    hildon_pannable_area_add_with_viewport(gobj(), child);
  else
    gtk_container_add(Gtk::Container::gobj(), child);
}

} // namespace Hildon

namespace
{


static void PannableArea_signal_horizontal_movement_callback(HildonPannableArea* self, HildonMovementDirection p0,gdouble p1,gdouble p2,void* data)
{
  using namespace Hildon;
  typedef sigc::slot< void,MovementDirection,double,double > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((MovementDirection)(p0))
, p1
, p2
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PannableArea_signal_horizontal_movement_info =
{
  "horizontal-movement",
  (GCallback) &PannableArea_signal_horizontal_movement_callback,
  (GCallback) &PannableArea_signal_horizontal_movement_callback
};


static void PannableArea_signal_vertical_movement_callback(HildonPannableArea* self, HildonMovementDirection p0,gdouble p1,gdouble p2,void* data)
{
  using namespace Hildon;
  typedef sigc::slot< void,MovementDirection,double,double > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(((MovementDirection)(p0))
, p1
, p2
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo PannableArea_signal_vertical_movement_info =
{
  "vertical-movement",
  (GCallback) &PannableArea_signal_vertical_movement_callback,
  (GCallback) &PannableArea_signal_vertical_movement_callback
};


} // anonymous namespace

// static
GType Glib::Value<Hildon::PannableAreaMode>::value_type()
{
  return hildon_pannable_area_mode_get_type();
}

// static
GType Glib::Value<Hildon::MovementMode>::value_type()
{
  return hildon_movement_mode_get_type();
}

// static
GType Glib::Value<Hildon::MovementDirection>::value_type()
{
  return hildon_movement_direction_get_type();
}

// static
GType Glib::Value<Hildon::SizeRequestPolicy>::value_type()
{
  return hildon_size_request_policy_get_type();
}


namespace Glib
{

Hildon::PannableArea* wrap(HildonPannableArea* object, bool take_copy)
{
  return dynamic_cast<Hildon::PannableArea *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Hildon
{


/* The *_Class implementation: */

const Glib::Class& PannableArea_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &PannableArea_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(hildon_pannable_area_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}

void PannableArea_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  klass->horizontal_movement = &horizontal_movement_callback;
  klass->vertical_movement = &vertical_movement_callback;
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void PannableArea_Class::horizontal_movement_callback(HildonPannableArea* self, HildonMovementDirection p0, gdouble p1, gdouble p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_horizontal_movement(((MovementDirection)(p0))
, p1
, p2
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->horizontal_movement)
    (*base->horizontal_movement)(self, p0, p1, p2);
}
void PannableArea_Class::vertical_movement_callback(HildonPannableArea* self, HildonMovementDirection p0, gdouble p1, gdouble p2)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_vertical_movement(((MovementDirection)(p0))
, p1
, p2
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }
  
  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->vertical_movement)
    (*base->vertical_movement)(self, p0, p1, p2);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* PannableArea_Class::wrap_new(GObject* o)
{
  return manage(new PannableArea((HildonPannableArea*)(o)));

}


/* The implementation: */

PannableArea::PannableArea(const Glib::ConstructParams& construct_params)
:
  Gtk::Bin(construct_params)
{
  }

PannableArea::PannableArea(HildonPannableArea* castitem)
:
  Gtk::Bin((GtkBin*)(castitem))
{
  }

PannableArea::~PannableArea()
{
  destroy_();
}

PannableArea::CppClassType PannableArea::pannablearea_class_; // initialize static member

GType PannableArea::get_type()
{
  return pannablearea_class_.init().get_type();
}

GType PannableArea::get_base_type()
{
  return hildon_pannable_area_get_type();
}


PannableArea::PannableArea()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Bin(Glib::ConstructParams(pannablearea_class_.init()))
{
  

}

PannableArea::PannableArea(PannableAreaMode mode, bool enabled, double velocity_min, double velocity_max, double deceleration, guint sps)
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Gtk::Bin(Glib::ConstructParams(pannablearea_class_.init(), "mode", static_cast<gint>(mode), "enabled", static_cast<int>(enabled), "velocity_min", velocity_min, "velocity_max", velocity_max, "deceleration", deceleration, "sps", sps, static_cast<char*>(0)))
{
  

}

void PannableArea::scroll_to(int x, int y)
{
hildon_pannable_area_scroll_to(gobj(), x, y); 
}

void PannableArea::jump_to(int x, int y)
{
hildon_pannable_area_jump_to(gobj(), x, y); 
}

void PannableArea::scroll_to_child(const Gtk::Widget& child)
{
hildon_pannable_area_scroll_to_child(gobj(), const_cast<GtkWidget*>((child).gobj())); 
}

void PannableArea::jump_to_child(const Gtk::Widget& child)
{
hildon_pannable_area_jump_to_child(gobj(), const_cast<GtkWidget*>((child).gobj())); 
}

Gtk::Widget* PannableArea::get_child_at(double x, double y)
{
  return Glib::wrap(hildon_pannable_get_child_widget_at(gobj(), x, y));
}

const Gtk::Widget* PannableArea::get_child_at(double x, double y) const
{
  return const_cast<PannableArea*>(this)->get_child_at(x, y);
}

SizeRequestPolicy PannableArea::get_size_request_policy() const
{
  return ((SizeRequestPolicy)(hildon_pannable_area_get_size_request_policy(const_cast<HildonPannableArea*>(gobj()))));
}

void PannableArea::set_size_request_policy(SizeRequestPolicy size_request_policy)
{
hildon_pannable_area_set_size_request_policy(gobj(), ((HildonSizeRequestPolicy)(size_request_policy))); 
}

Gtk::Adjustment* PannableArea::get_hadjustment()
{
  return Glib::wrap(hildon_pannable_area_get_hadjustment(gobj()));
}

const Gtk::Adjustment* PannableArea::get_hadjustment() const
{
  return const_cast<PannableArea*>(this)->get_hadjustment();
}

Gtk::Adjustment* PannableArea::get_vadjustment()
{
  return Glib::wrap(hildon_pannable_area_get_vadjustment(gobj()));
}

const Gtk::Adjustment* PannableArea::get_vadjustment() const
{
  return const_cast<PannableArea*>(this)->get_vadjustment();
}


Glib::SignalProxy3< void,MovementDirection,double,double > PannableArea::signal_horizontal_movement()
{
  return Glib::SignalProxy3< void,MovementDirection,double,double >(this, &PannableArea_signal_horizontal_movement_info);
}


Glib::SignalProxy3< void,MovementDirection,double,double > PannableArea::signal_vertical_movement()
{
  return Glib::SignalProxy3< void,MovementDirection,double,double >(this, &PannableArea_signal_vertical_movement_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PannableArea::property_enabled() 
{
  return Glib::PropertyProxy<bool>(this, "enabled");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PannableArea::property_enabled() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "enabled");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gtk::PolicyType> PannableArea::property_vscrollbar_policy() 
{
  return Glib::PropertyProxy<Gtk::PolicyType>(this, "vscrollbar-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gtk::PolicyType> PannableArea::property_vscrollbar_policy() const
{
  return Glib::PropertyProxy_ReadOnly<Gtk::PolicyType>(this, "vscrollbar-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Gtk::PolicyType> PannableArea::property_hscrollbar_policy() 
{
  return Glib::PropertyProxy<Gtk::PolicyType>(this, "hscrollbar-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gtk::PolicyType> PannableArea::property_hscrollbar_policy() const
{
  return Glib::PropertyProxy_ReadOnly<Gtk::PolicyType>(this, "hscrollbar-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<PannableAreaMode> PannableArea::property_mode() 
{
  return Glib::PropertyProxy<PannableAreaMode>(this, "mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<PannableAreaMode> PannableArea::property_mode() const
{
  return Glib::PropertyProxy_ReadOnly<PannableAreaMode>(this, "mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<MovementMode> PannableArea::property_mov_mode() 
{
  return Glib::PropertyProxy<MovementMode>(this, "mov-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<MovementMode> PannableArea::property_mov_mode() const
{
  return Glib::PropertyProxy_ReadOnly<MovementMode>(this, "mov-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> PannableArea::property_velocity_min() 
{
  return Glib::PropertyProxy<double>(this, "velocity-min");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> PannableArea::property_velocity_min() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "velocity-min");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> PannableArea::property_velocity_max() 
{
  return Glib::PropertyProxy<double>(this, "velocity-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> PannableArea::property_velocity_max() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "velocity-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> PannableArea::property_velocity_fast_factor() 
{
  return Glib::PropertyProxy<double>(this, "velocity-fast-factor");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> PannableArea::property_velocity_fast_factor() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "velocity-fast-factor");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> PannableArea::property_deceleration() 
{
  return Glib::PropertyProxy<double>(this, "deceleration");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> PannableArea::property_deceleration() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "deceleration");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<unsigned int> PannableArea::property_sps() 
{
  return Glib::PropertyProxy<unsigned int>(this, "sps");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<unsigned int> PannableArea::property_sps() const
{
  return Glib::PropertyProxy_ReadOnly<unsigned int>(this, "sps");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> PannableArea::property_vovershoot_max() 
{
  return Glib::PropertyProxy<int>(this, "vovershoot-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> PannableArea::property_vovershoot_max() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "vovershoot-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> PannableArea::property_hovershoot_max() 
{
  return Glib::PropertyProxy<int>(this, "hovershoot-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> PannableArea::property_hovershoot_max() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "hovershoot-max");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> PannableArea::property_scroll_time() 
{
  return Glib::PropertyProxy<double>(this, "scroll-time");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> PannableArea::property_scroll_time() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "scroll-time");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PannableArea::property_initial_hint() 
{
  return Glib::PropertyProxy<bool>(this, "initial-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PannableArea::property_initial_hint() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "initial-hint");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> PannableArea::property_low_friction_mode() 
{
  return Glib::PropertyProxy<bool>(this, "low-friction-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> PannableArea::property_low_friction_mode() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "low-friction-mode");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<SizeRequestPolicy> PannableArea::property_size_request_policy() 
{
  return Glib::PropertyProxy<SizeRequestPolicy>(this, "size-request-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<SizeRequestPolicy> PannableArea::property_size_request_policy() const
{
  return Glib::PropertyProxy_ReadOnly<SizeRequestPolicy>(this, "size-request-policy");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> PannableArea::property_hadjustment() const
{
  return Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*>(this, "hadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*> PannableArea::property_vadjustment() const
{
  return Glib::PropertyProxy_ReadOnly<Gtk::Adjustment*>(this, "vadjustment");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
void Hildon::PannableArea::on_horizontal_movement(MovementDirection direction, double x, double y)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->horizontal_movement)
    (*base->horizontal_movement)(gobj(),((HildonMovementDirection)(direction)),x,y);
}
void Hildon::PannableArea::on_vertical_movement(MovementDirection direction, double x, double y)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->vertical_movement)
    (*base->vertical_movement)(gobj(),((HildonMovementDirection)(direction)),x,y);
}
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Hildon


